/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.distribution;

import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.RandomProviderState;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.PermutationSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.PoissonSampler;
import org.apache.commons.rng.sampling.distribution.PoissonSamplerCache;
import org.apache.commons.rng.simple.RandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class PoissonSamplerCachePerformance {
    private static final int NUM_SAMPLES = 100000;
    private static final int RANGE_SAMPLE_SIZE = 4099;
    private static final int SEED_SIZE = 128;
    private static final int[] SEED = new int[128];
    private static final double[] RANGE_SAMPLE;

    private static void runSample(PoissonSamplerFactory factory, MeanRange range, Blackhole bh) {
        for (int i = 0; i < 100000; ++i) {
            bh.consume(factory.createPoissonSampler(range.getMean(i)).sample());
        }
    }

    @Benchmark
    public void runPoissonSampler(Sources sources, MeanRange range, Blackhole bh) {
        final UniformRandomProvider r = sources.getGenerator();
        PoissonSamplerFactory factory = new PoissonSamplerFactory(){

            @Override
            public DiscreteSampler createPoissonSampler(double mean) {
                return new PoissonSampler(r, mean);
            }
        };
        PoissonSamplerCachePerformance.runSample(factory, range, bh);
    }

    @Benchmark
    public void runPoissonSamplerCacheWhenEmpty(Sources sources, MeanRange range, Blackhole bh) {
        final UniformRandomProvider r = sources.getGenerator();
        final PoissonSamplerCache cache = new PoissonSamplerCache(0.0, 0.0);
        PoissonSamplerFactory factory = new PoissonSamplerFactory(){

            @Override
            public DiscreteSampler createPoissonSampler(double mean) {
                return cache.createPoissonSampler(r, mean);
            }
        };
        PoissonSamplerCachePerformance.runSample(factory, range, bh);
    }

    @Benchmark
    public void runPoissonSamplerCache(Sources sources, MeanRange range, Blackhole bh) {
        final UniformRandomProvider r = sources.getGenerator();
        final PoissonSamplerCache cache = new PoissonSamplerCache(range.getMin(), range.getMax());
        PoissonSamplerFactory factory = new PoissonSamplerFactory(){

            @Override
            public DiscreteSampler createPoissonSampler(double mean) {
                return cache.createPoissonSampler(r, mean);
            }
        };
        PoissonSamplerCachePerformance.runSample(factory, range, bh);
    }

    static {
        RestorableUniformRandomProvider rng = RandomSource.create((RandomSource)RandomSource.MWC_256);
        for (int i = 0; i < SEED.length; ++i) {
            PoissonSamplerCachePerformance.SEED[i] = rng.nextInt();
        }
        int size = 4099;
        int[] sample = PermutationSampler.natural((int)4099);
        PermutationSampler.shuffle((UniformRandomProvider)rng, (int[])sample);
        RANGE_SAMPLE = new double[4099];
        for (int i = 0; i < 4099; ++i) {
            PoissonSamplerCachePerformance.RANGE_SAMPLE[i] = (double)sample[i] / 4099.0;
        }
    }

    private static interface PoissonSamplerFactory {
        public DiscreteSampler createPoissonSampler(double var1);
    }

    @State(value=Scope.Benchmark)
    public static class MeanRange {
        @Param(value={"1", "4", "16", "64", "256", "1024", "4096"})
        private double range;

        public double getMean(int i) {
            return this.getMin() + RANGE_SAMPLE[i % RANGE_SAMPLE.length] * this.range;
        }

        public double getMin() {
            return PoissonSamplerCache.getMinimumCachedMean();
        }

        public double getMax() {
            return this.getMin() + this.range;
        }
    }

    @State(value=Scope.Benchmark)
    public static class Sources {
        @Param(value={"SPLIT_MIX_64"})
        private String randomSourceName;
        private RestorableUniformRandomProvider generator;
        private RandomProviderState state;

        public UniformRandomProvider getGenerator() {
            this.generator.restoreState(this.state);
            return this.generator;
        }

        @Setup
        public void setup() {
            RandomSource randomSource = RandomSource.valueOf((String)this.randomSourceName);
            this.generator = RandomSource.create((RandomSource)randomSource, (Object)SEED.clone(), (Object[])new Object[0]);
            this.state = this.generator.saveState();
        }
    }
}

