/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.distribution;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class NextGaussianPerformance {
    private static final int NUM_SAMPLES = 10000000;
    private final Random random = new Random();

    private void runSample(Blackhole bh) {
        for (int i = 0; i < 10000000; ++i) {
            bh.consume(this.random.nextGaussian());
        }
    }

    @Benchmark
    public void runJDKRandomGaussianSampler(Blackhole bh) {
        this.runSample(bh);
    }
}

