/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.simple;

import java.util.UUID;
import org.apache.commons.rdf.api.BlankNode;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.commons.rdf.simple.BlankNodeImpl;
import org.apache.commons.rdf.simple.DatasetImpl;
import org.apache.commons.rdf.simple.GraphImpl;
import org.apache.commons.rdf.simple.IRIImpl;
import org.apache.commons.rdf.simple.LiteralImpl;
import org.apache.commons.rdf.simple.QuadImpl;
import org.apache.commons.rdf.simple.TripleImpl;
import org.apache.commons.rdf.simple.Types;

public class SimpleRDF
implements RDF {
    private final UUID SALT = UUID.randomUUID();

    public BlankNode createBlankNode() {
        return new BlankNodeImpl();
    }

    public BlankNode createBlankNode(String name) {
        return new BlankNodeImpl(this.SALT, name);
    }

    public Graph createGraph() {
        return new GraphImpl(this);
    }

    public Dataset createDataset() throws UnsupportedOperationException {
        return new DatasetImpl(this);
    }

    public IRI createIRI(String iri) {
        IRIImpl result = new IRIImpl(iri);
        return Types.get(result).orElse(result);
    }

    public Literal createLiteral(String literal) {
        return new LiteralImpl(literal);
    }

    public Literal createLiteral(String literal, IRI dataType) {
        return new LiteralImpl(literal, dataType);
    }

    public Literal createLiteral(String literal, String language) {
        return new LiteralImpl(literal, language);
    }

    public Triple createTriple(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return new TripleImpl(subject, predicate, object);
    }

    public Quad createQuad(BlankNodeOrIRI graphName, BlankNodeOrIRI subject, IRI predicate, RDFTerm object) throws IllegalArgumentException {
        return new QuadImpl(graphName, subject, predicate, object);
    }

    static interface SimpleRDFTerm
    extends RDFTerm {
    }
}

