/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.simple;

import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.simple.SimpleRDF;
import org.apache.commons.rdf.simple.Types;

final class LiteralImpl
implements Literal,
SimpleRDF.SimpleRDFTerm {
    private static final String QUOTE = "\"";
    private final IRI dataType;
    private final String languageTag;
    private final String lexicalForm;

    public LiteralImpl(String literal) {
        this(literal, Types.XSD_STRING);
    }

    public LiteralImpl(String lexicalForm, IRI dataType) {
        this.lexicalForm = Objects.requireNonNull(lexicalForm);
        this.dataType = Types.get(Objects.requireNonNull(dataType)).orElse(dataType);
        if (Types.RDF_LANGSTRING.equals(this.dataType)) {
            throw new IllegalArgumentException("Cannot create a non-language literal with type " + Types.RDF_LANGSTRING);
        }
        this.languageTag = null;
    }

    public LiteralImpl(String literal, String languageTag) {
        this.lexicalForm = Objects.requireNonNull(literal);
        this.languageTag = Objects.requireNonNull(LiteralImpl.lowerCase(languageTag));
        if (languageTag.isEmpty()) {
            throw new IllegalArgumentException("Language tag can't be null");
        }
        try {
            new Locale.Builder().setLanguageTag(languageTag);
        }
        catch (IllformedLocaleException ex) {
            throw new IllegalArgumentException("Invalid languageTag: " + languageTag, ex);
        }
        this.dataType = Types.RDF_LANGSTRING;
    }

    public IRI getDatatype() {
        return this.dataType;
    }

    public Optional<String> getLanguageTag() {
        return Optional.ofNullable(this.languageTag);
    }

    public String getLexicalForm() {
        return this.lexicalForm;
    }

    public String ntriplesString() {
        StringBuilder sb = new StringBuilder();
        sb.append(QUOTE);
        sb.append(this.getLexicalForm().replace("\\", "\\\\").replace(QUOTE, "\\\"").replace("\r", "\\r").replace("\n", "\\n"));
        sb.append(QUOTE);
        if (this.getLanguageTag().isPresent()) {
            sb.append("@");
            sb.append(this.getLanguageTag().get());
        } else if (!this.getDatatype().equals((Object)Types.XSD_STRING)) {
            sb.append("^^");
            sb.append(this.getDatatype().ntriplesString());
        }
        return sb.toString();
    }

    public String toString() {
        return this.ntriplesString();
    }

    public int hashCode() {
        return Objects.hash(this.lexicalForm, this.dataType, this.languageTag);
    }

    private static String lowerCase(String langTag) {
        return langTag.toLowerCase(Locale.ROOT);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Literal)) {
            return false;
        }
        Literal literal = (Literal)obj;
        return this.getDatatype().equals((Object)literal.getDatatype()) && this.getLexicalForm().equals(literal.getLexicalForm()) && this.getLanguageTag().equals(literal.getLanguageTag().map(LiteralImpl::lowerCase));
    }
}

