/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.provider;

import java.io.Serializable;
import org.apache.commons.proxy.ObjectProvider;
import org.apache.commons.proxy.exception.ObjectProviderException;

public class BeanProvider
implements ObjectProvider,
Serializable {
    private Class beanClass;

    public BeanProvider() {
    }

    public BeanProvider(Class beanClass) {
        this.beanClass = beanClass;
    }

    public Object getObject() {
        try {
            if (this.beanClass == null) {
                throw new ObjectProviderException("No bean class provided.");
            }
            return this.beanClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ObjectProviderException("Class " + this.beanClass.getName() + " is not concrete.", e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectProviderException("Constructor for class " + this.beanClass.getName() + " is not accessible.", e);
        }
    }

    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }
}

