/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.interceptor.logging;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.proxy.interceptor.logging.AbstractLoggingInterceptor;

public class JdkLoggingInterceptor
extends AbstractLoggingInterceptor {
    private final String loggerName;

    public JdkLoggingInterceptor(Class clazz) {
        this(clazz.getName());
    }

    public JdkLoggingInterceptor(String loggerName) {
        this.loggerName = loggerName;
    }

    private Logger getLogger() {
        return Logger.getLogger(this.loggerName);
    }

    protected void entering(Method method, Object[] args) {
        this.getLogger().entering(method.getDeclaringClass().getName(), method.getName(), args);
    }

    protected void exiting(Method method, Object result) {
        this.getLogger().exiting(method.getDeclaringClass().getName(), method.getName(), result);
    }

    protected boolean isLoggingEnabled() {
        return this.getLogger().isLoggable(Level.FINER);
    }

    protected void logMessage(String message) {
    }

    protected void logMessage(String message, Throwable t) {
    }

    protected void throwing(Method method, Throwable t) {
        this.getLogger().throwing(method.getDeclaringClass().getName(), method.getName(), t);
    }
}

