/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.interceptor.logging;

import java.lang.reflect.Method;
import org.apache.commons.proxy.Interceptor;
import org.apache.commons.proxy.Invocation;
import org.apache.commons.proxy.ProxyUtils;

public abstract class AbstractLoggingInterceptor
implements Interceptor {
    private static final int BUFFER_SIZE = 100;

    protected abstract boolean isLoggingEnabled();

    protected abstract void logMessage(String var1);

    protected abstract void logMessage(String var1, Throwable var2);

    public Object intercept(Invocation invocation) throws Throwable {
        if (this.isLoggingEnabled()) {
            Method method = invocation.getMethod();
            this.entering(method, invocation.getArguments());
            try {
                Object result = invocation.proceed();
                this.exiting(method, result);
                return result;
            }
            catch (Throwable t) {
                this.throwing(method, t);
                throw t;
            }
        }
        return invocation.proceed();
    }

    protected void entering(Method method, Object[] args) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("BEGIN ");
        buffer.append(method.getName());
        buffer.append("(");
        int count = args.length;
        for (int i = 0; i < count; ++i) {
            Object arg = args[i];
            if (i > 0) {
                buffer.append(", ");
            }
            this.convert(buffer, arg);
        }
        buffer.append(")");
        this.logMessage(buffer.toString());
    }

    protected void convert(StringBuffer buffer, Object input) {
        if (input == null) {
            buffer.append("<null>");
            return;
        }
        if (!(input instanceof Object[])) {
            buffer.append(input.toString());
            return;
        }
        buffer.append("(");
        buffer.append(ProxyUtils.getJavaClassName(input.getClass()));
        buffer.append("){");
        Object[] array = (Object[])input;
        int count = array.length;
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.convert(buffer, array[i]);
        }
        buffer.append("}");
    }

    protected void exiting(Method method, Object result) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("END ");
        buffer.append(method.getName());
        buffer.append("()");
        if (!Void.TYPE.equals(method.getReturnType())) {
            buffer.append(" [");
            this.convert(buffer, result);
            buffer.append("]");
        }
        this.logMessage(buffer.toString());
    }

    protected void throwing(Method method, Throwable t) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("EXCEPTION ");
        buffer.append(method);
        buffer.append("() -- ");
        buffer.append(t.getClass().getName());
        this.logMessage(buffer.toString(), t);
    }
}

