/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.factory.javassist;

import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.apache.commons.proxy.ProxyUtils;
import org.apache.commons.proxy.exception.ObjectProviderException;

class JavassistUtils {
    public static final String DEFAULT_BASE_NAME = "JavassistUtilsGenerated";
    private static int classNumber = 0;
    private static final ClassPool classPool = new ClassPool();
    private static final Set classLoaders = new HashSet();

    JavassistUtils() {
    }

    public static void addField(Class fieldType, String fieldName, CtClass enclosingClass) throws CannotCompileException {
        enclosingClass.addField(new CtField(JavassistUtils.resolve(fieldType), fieldName, enclosingClass));
    }

    public static void addInterfaces(CtClass ctClass, Class[] proxyClasses) {
        for (int i = 0; i < proxyClasses.length; ++i) {
            Class proxyInterface = proxyClasses[i];
            ctClass.addInterface(JavassistUtils.resolve(proxyInterface));
        }
    }

    public static CtClass createClass(Class superclass) {
        return JavassistUtils.createClass(DEFAULT_BASE_NAME, superclass);
    }

    public static synchronized CtClass createClass(String baseName, Class superclass) {
        return classPool.makeClass(baseName + "_" + classNumber++, JavassistUtils.resolve(superclass));
    }

    public static CtClass resolve(Class clazz) {
        Set set = classLoaders;
        synchronized (set) {
            try {
                ClassLoader loader = clazz.getClassLoader();
                if (loader != null && !classLoaders.contains(loader)) {
                    classLoaders.add(loader);
                    classPool.appendClassPath((ClassPath)new LoaderClassPath(loader));
                }
                return classPool.get(ProxyUtils.getJavaClassName(clazz));
            }
            catch (NotFoundException e) {
                throw new ObjectProviderException("Unable to find class " + clazz.getName() + " in default Javassist class pool.", e);
            }
        }
    }

    public static CtClass[] resolve(Class[] classes) {
        CtClass[] ctClasses = new CtClass[classes.length];
        for (int i = 0; i < ctClasses.length; ++i) {
            ctClasses[i] = JavassistUtils.resolve(classes[i]);
        }
        return ctClasses;
    }

    static {
        classPool.appendClassPath((ClassPath)new LoaderClassPath(ClassLoader.getSystemClassLoader()));
    }
}

