/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.proxy.ProxyFactory;
import org.apache.commons.proxy.invoker.NullInvoker;

public class ProxyUtils {
    public static final Object[] EMPTY_ARGUMENTS = new Object[0];
    public static final Class[] EMPTY_ARGUMENT_TYPES = new Class[0];
    private static final Map wrapperClassMap = new HashMap();
    public static Map defaultValueMap = new HashMap();

    public static Object createNullObject(ProxyFactory proxyFactory, Class[] proxyClasses) {
        return proxyFactory.createInvokerProxy(new NullInvoker(), proxyClasses);
    }

    public static Object createNullObject(ProxyFactory proxyFactory, ClassLoader classLoader, Class[] proxyClasses) {
        return proxyFactory.createInvokerProxy(classLoader, new NullInvoker(), proxyClasses);
    }

    public static Class[] getAllInterfaces(Class cls) {
        List interfaces = ProxyUtils.getAllInterfacesImpl(cls, new LinkedList());
        return interfaces == null ? null : interfaces.toArray(new Class[interfaces.size()]);
    }

    private static List getAllInterfacesImpl(Class cls, List list) {
        if (cls == null) {
            return null;
        }
        while (cls != null) {
            Class<?>[] interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!list.contains(interfaces[i])) {
                    list.add(interfaces[i]);
                }
                ProxyUtils.getAllInterfacesImpl(interfaces[i], list);
            }
            cls = cls.getSuperclass();
        }
        return list;
    }

    public static String getJavaClassName(Class clazz) {
        if (clazz.isArray()) {
            return ProxyUtils.getJavaClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static Class getWrapperClass(Class primitiveType) {
        return (Class)wrapperClassMap.get(primitiveType);
    }

    public static Object getDefaultValue(Class type) {
        if (type.isPrimitive()) {
            return defaultValueMap.get(type);
        }
        return null;
    }

    static {
        wrapperClassMap.put(Integer.TYPE, Integer.class);
        wrapperClassMap.put(Character.TYPE, Character.class);
        wrapperClassMap.put(Boolean.TYPE, Boolean.class);
        wrapperClassMap.put(Short.TYPE, Short.class);
        wrapperClassMap.put(Long.TYPE, Long.class);
        wrapperClassMap.put(Float.TYPE, Float.class);
        wrapperClassMap.put(Double.TYPE, Double.class);
        wrapperClassMap.put(Byte.TYPE, Byte.class);
        defaultValueMap.put(Integer.TYPE, new Integer(0));
        defaultValueMap.put(Long.TYPE, new Long(0L));
        defaultValueMap.put(Short.TYPE, new Short(0));
        defaultValueMap.put(Byte.TYPE, new Byte(0));
        defaultValueMap.put(Float.TYPE, new Float(0.0f));
        defaultValueMap.put(Double.TYPE, new Double(0.0));
        defaultValueMap.put(Character.TYPE, new Character('\u0000'));
        defaultValueMap.put(Boolean.TYPE, Boolean.FALSE);
    }
}

