/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.ml.neuralnet.twod.util;

import java.util.List;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.ml.distance.DistanceMeasure;
import org.apache.commons.math4.ml.neuralnet.MapRanking;
import org.apache.commons.math4.ml.neuralnet.Neuron;
import org.apache.commons.math4.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math4.ml.neuralnet.twod.util.LocationFinder;
import org.apache.commons.math4.ml.neuralnet.twod.util.MapDataVisualization;

public class SmoothedDataHistogram
implements MapDataVisualization {
    private final int smoothingBins;
    private final DistanceMeasure distance;
    private final double membershipNormalization;

    public SmoothedDataHistogram(int smoothingBins, DistanceMeasure distance) {
        this.smoothingBins = smoothingBins;
        this.distance = distance;
        double sum = 0.0;
        for (int i = 0; i < smoothingBins; ++i) {
            sum += (double)(smoothingBins - i);
        }
        this.membershipNormalization = 1.0 / sum;
    }

    @Override
    public double[][] computeImage(NeuronSquareMesh2D map, Iterable<double[]> data) {
        int nC;
        int nR = map.getNumberOfRows();
        int mapSize = nR * (nC = map.getNumberOfColumns());
        if (mapSize < this.smoothingBins) {
            throw new NumberIsTooSmallException(mapSize, (Number)this.smoothingBins, true);
        }
        LocationFinder finder = new LocationFinder(map);
        MapRanking rank = new MapRanking(map.getNetwork(), this.distance);
        double[][] histo = new double[nR][nC];
        for (double[] sample : data) {
            List<Neuron> sorted = rank.rank(sample);
            for (int i = 0; i < this.smoothingBins; ++i) {
                LocationFinder.Location loc = finder.getLocation(sorted.get(i));
                int row = loc.getRow();
                int col = loc.getColumn();
                double[] dArray = histo[row];
                int n = col;
                dArray[n] = dArray[n] + (double)(this.smoothingBins - i) * this.membershipNormalization;
            }
        }
        return histo;
    }
}

