/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.ml.clustering.evaluation;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math4.exception.InsufficientDataException;
import org.apache.commons.math4.ml.clustering.Cluster;
import org.apache.commons.math4.ml.clustering.ClusterEvaluator;
import org.apache.commons.math4.ml.clustering.Clusterable;
import org.apache.commons.math4.util.MathArrays;

public class CalinskiHarabasz
implements ClusterEvaluator {
    @Override
    public double score(List<? extends Cluster<? extends Clusterable>> clusters) {
        int dimension = this.dimensionOfClusters(clusters);
        double[] centroid = this.meanOfClusters(clusters, dimension);
        double intraDistanceProduct = 0.0;
        double extraDistanceProduct = 0.0;
        for (Cluster<? extends Clusterable> cluster : clusters) {
            double[] clusterCentroid = this.mean(cluster.getPoints(), dimension);
            for (Clusterable clusterable : cluster.getPoints()) {
                intraDistanceProduct += this.covariance(clusterCentroid, clusterable.getPoint());
            }
            extraDistanceProduct += (double)cluster.getPoints().size() * this.covariance(centroid, clusterCentroid);
        }
        int pointCount = this.countAllPoints(clusters);
        int n = clusters.size();
        return intraDistanceProduct == 0.0 ? 1.0 : extraDistanceProduct * (double)(pointCount - n) / (intraDistanceProduct * (double)(n - 1));
    }

    @Override
    public boolean isBetterScore(double a, double b) {
        return a > b;
    }

    private double covariance(double[] p1, double[] p2) {
        MathArrays.checkEqualLength(p1, p2);
        double sum = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double dp = p1[i] - p2[i];
            sum += dp * dp;
        }
        return sum;
    }

    private double[] mean(Collection<? extends Clusterable> points, int dimension) {
        double[] centroid = new double[dimension];
        for (Clusterable clusterable : points) {
            double[] point = clusterable.getPoint();
            for (int i = 0; i < centroid.length; ++i) {
                int n = i;
                centroid[n] = centroid[n] + point[i];
            }
        }
        int i = 0;
        while (i < centroid.length) {
            int n = i++;
            centroid[n] = centroid[n] / (double)points.size();
        }
        return centroid;
    }

    private double[] meanOfClusters(Collection<? extends Cluster<? extends Clusterable>> clusters, int dimension) {
        double[] centroid = new double[dimension];
        int allPointsCount = 0;
        for (Cluster<? extends Clusterable> cluster : clusters) {
            for (Clusterable clusterable : cluster.getPoints()) {
                double[] point = clusterable.getPoint();
                for (int i = 0; i < centroid.length; ++i) {
                    int n = i;
                    centroid[n] = centroid[n] + point[i];
                }
                ++allPointsCount;
            }
        }
        int i = 0;
        while (i < centroid.length) {
            int n = i++;
            centroid[n] = centroid[n] / (double)allPointsCount;
        }
        return centroid;
    }

    private int countAllPoints(Collection<? extends Cluster<? extends Clusterable>> clusters) {
        int pointCount = 0;
        for (Cluster<? extends Clusterable> cluster : clusters) {
            pointCount += cluster.getPoints().size();
        }
        return pointCount;
    }

    private int dimensionOfClusters(Collection<? extends Cluster<? extends Clusterable>> clusters) {
        for (Cluster<? extends Clusterable> cluster : clusters) {
            Iterator<? extends Clusterable> iterator = cluster.getPoints().iterator();
            if (!iterator.hasNext()) continue;
            Clusterable p = iterator.next();
            return p.getPoint().length;
        }
        throw new InsufficientDataException();
    }
}

