/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.linear.MatrixDimensionMismatchException;

public interface AnyMatrix {
    default public boolean isSquare() {
        return this.getRowDimension() == this.getColumnDimension();
    }

    public int getRowDimension();

    public int getColumnDimension();

    default public boolean canAdd(AnyMatrix other) {
        return this.getRowDimension() == other.getRowDimension() && this.getColumnDimension() == other.getColumnDimension();
    }

    default public void checkAdd(AnyMatrix other) {
        if (!this.canAdd(other)) {
            throw new MatrixDimensionMismatchException(this.getRowDimension(), this.getColumnDimension(), other.getRowDimension(), other.getColumnDimension());
        }
    }

    default public boolean canMultiply(AnyMatrix other) {
        return this.getColumnDimension() == other.getRowDimension();
    }

    default public void checkMultiply(AnyMatrix other) {
        if (!this.canMultiply(other)) {
            throw new DimensionMismatchException(this.getColumnDimension(), other.getRowDimension());
        }
    }
}

