/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.exception;

import org.apache.commons.math4.exception.MathIllegalNumberException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;

public class OutOfRangeException
extends MathIllegalNumberException {
    private static final long serialVersionUID = 111601815794403609L;
    private final Number lo;
    private final Number hi;

    public OutOfRangeException(Number wrong, Number lo, Number hi) {
        super((Localizable)LocalizedFormats.OUT_OF_RANGE_SIMPLE, wrong, lo, hi);
        this.lo = lo;
        this.hi = hi;
    }

    public OutOfRangeException(Localizable specific, Number wrong, Number lo, Number hi) {
        this(wrong, lo, hi);
        this.getContext().addMessage(specific, wrong, lo, hi);
    }

    public Number getLo() {
        return this.lo;
    }

    public Number getHi() {
        return this.hi;
    }
}

