/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.distribution.MixtureMultivariateRealDistribution;
import org.apache.commons.math4.distribution.MultivariateNormalDistribution;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.util.Pair;

public class MixtureMultivariateNormalDistribution
extends MixtureMultivariateRealDistribution<MultivariateNormalDistribution> {
    public MixtureMultivariateNormalDistribution(List<Pair<Double, MultivariateNormalDistribution>> components) throws NotPositiveException, DimensionMismatchException {
        super(components);
    }

    public MixtureMultivariateNormalDistribution(double[] weights, double[][] means, double[][][] covariances) throws NotPositiveException, DimensionMismatchException {
        this(MixtureMultivariateNormalDistribution.createComponents(weights, means, covariances));
    }

    private static List<Pair<Double, MultivariateNormalDistribution>> createComponents(double[] weights, double[][] means, double[][][] covariances) {
        ArrayList<Pair<Double, MultivariateNormalDistribution>> mvns = new ArrayList<Pair<Double, MultivariateNormalDistribution>>(weights.length);
        for (int i = 0; i < weights.length; ++i) {
            MultivariateNormalDistribution dist = new MultivariateNormalDistribution(means[i], covariances[i]);
            mvns.add(new Pair<Double, MultivariateNormalDistribution>(weights[i], dist));
        }
        return mvns;
    }
}

