/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet.sofm;

import org.apache.commons.math4.neuralnet.internal.NeuralNetException;
import org.apache.commons.math4.neuralnet.sofm.LearningFactorFunction;
import org.apache.commons.math4.neuralnet.sofm.util.ExponentialDecayFunction;
import org.apache.commons.math4.neuralnet.sofm.util.QuasiSigmoidDecayFunction;

public final class LearningFactorFunctionFactory {
    private LearningFactorFunctionFactory() {
    }

    public static LearningFactorFunction exponentialDecay(final double initValue, final double valueAtNumCall, final long numCall) {
        if (initValue <= 0.0 || initValue > 1.0) {
            throw new NeuralNetException("Number {0} is out of range [{1}, {2}]", initValue, 0, 1);
        }
        return new LearningFactorFunction(){
            private final ExponentialDecayFunction decay;
            {
                this.decay = new ExponentialDecayFunction(initValue, valueAtNumCall, numCall);
            }

            @Override
            public double value(long n) {
                return this.decay.applyAsDouble(n);
            }
        };
    }

    public static LearningFactorFunction quasiSigmoidDecay(final double initValue, final double slope, final long numCall) {
        if (initValue <= 0.0 || initValue > 1.0) {
            throw new NeuralNetException("Number {0} is out of range [{1}, {2}]", initValue, 0, 1);
        }
        return new LearningFactorFunction(){
            private final QuasiSigmoidDecayFunction decay;
            {
                this.decay = new QuasiSigmoidDecayFunction(initValue, slope, numCall);
            }

            @Override
            public double value(long n) {
                return this.decay.applyAsDouble(n);
            }
        };
    }
}

