/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode;

import org.apache.commons.javaflow.ContinuationDeath;
import org.apache.commons.javaflow.bytecode.Stack;
import org.apache.commons.javaflow.utils.ReflectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StackRecorder
extends Stack {
    private static final Log log = LogFactory.getLog(StackRecorder.class);
    private static final long serialVersionUID = 2L;
    private static final ThreadLocal<StackRecorder> threadMap = new ThreadLocal();
    public transient boolean isRestoring = false;
    public transient boolean isCapturing = false;
    private transient Object context;
    public transient Object value;

    public StackRecorder(Runnable pTarget) {
        super(pTarget);
    }

    public StackRecorder(Stack pParent) {
        super(pParent);
    }

    public static Object suspend(Object value) {
        log.debug((Object)"suspend()");
        StackRecorder stackRecorder = StackRecorder.get();
        if (stackRecorder == null) {
            throw new IllegalStateException("No continuation is running");
        }
        stackRecorder.isCapturing = !stackRecorder.isRestoring;
        stackRecorder.isRestoring = false;
        stackRecorder.value = value;
        return stackRecorder.context;
    }

    public StackRecorder execute(Object context) {
        StackRecorder old = this.registerThread();
        try {
            this.isRestoring = !this.isEmpty();
            this.context = context;
            if (this.isRestoring && log.isDebugEnabled()) {
                log.debug((Object)("Restoring state of " + ReflectionUtils.getClassName(this.runnable) + "/" + ReflectionUtils.getClassLoaderName(this.runnable)));
            }
            log.debug((Object)"calling runnable");
            this.runnable.run();
            if (this.isCapturing) {
                if (this.isEmpty()) {
                    throw new IllegalStateException("stack corruption. Is " + this.runnable.getClass() + " instrumented for javaflow?");
                }
                this.popReference();
                StackRecorder stackRecorder = this;
                return stackRecorder;
            }
            StackRecorder stackRecorder = null;
            return stackRecorder;
        }
        catch (ContinuationDeath cd) {
            throw cd;
        }
        catch (Error e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.context = null;
            this.deregisterThread(old);
        }
    }

    public Object getContext() {
        return this.context;
    }

    private StackRecorder registerThread() {
        StackRecorder old = StackRecorder.get();
        threadMap.set(this);
        return old;
    }

    private void deregisterThread(StackRecorder old) {
        threadMap.set(old);
    }

    public static StackRecorder get() {
        return threadMap.get();
    }
}

