/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv247Test {
    @Test
    public void testHeadersMissingOneColumnWhenAllowingMissingColumnNames() throws Exception {
        CSVFormat format = CSVFormat.DEFAULT.builder().setHeader(new String[0]).setAllowMissingColumnNames(true).build();
        Assertions.assertTrue((boolean)format.getAllowMissingColumnNames(), (String)"We should allow missing column names");
        StringReader in = new StringReader("a,,c,d,e\n1,2,3,4,5\nv,w,x,y,z");
        try (CSVParser parser = format.parse((Reader)in);){
            Assertions.assertEquals(Arrays.asList("a", "", "c", "d", "e"), (Object)parser.getHeaderNames());
            Iterator iterator = parser.iterator();
            CSVRecord record = (CSVRecord)iterator.next();
            Assertions.assertEquals((Object)"1", (Object)record.get(0));
            Assertions.assertEquals((Object)"2", (Object)record.get(1));
            Assertions.assertEquals((Object)"3", (Object)record.get(2));
            Assertions.assertEquals((Object)"4", (Object)record.get(3));
            Assertions.assertEquals((Object)"5", (Object)record.get(4));
            record = (CSVRecord)iterator.next();
            Assertions.assertEquals((Object)"v", (Object)record.get(0));
            Assertions.assertEquals((Object)"w", (Object)record.get(1));
            Assertions.assertEquals((Object)"x", (Object)record.get(2));
            Assertions.assertEquals((Object)"y", (Object)record.get(3));
            Assertions.assertEquals((Object)"z", (Object)record.get(4));
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testHeadersMissingThrowsWhenNotAllowingMissingColumnNames() {
        CSVFormat format = CSVFormat.DEFAULT.builder().setHeader(new String[0]).build();
        Assertions.assertFalse((boolean)format.getAllowMissingColumnNames(), (String)"By default we should not allow missing column names");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            try (StringReader reader = new StringReader("a,,c,d,e\n1,2,3,4,5\nv,w,x,y,z");){
                CSVParser parser = format.parse((Reader)reader);
                Throwable throwable = null;
                if (parser != null) {
                    if (throwable != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        parser.close();
                    }
                }
            }
        }, (String)"1 missing column header is not allowed");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            try (StringReader reader = new StringReader("a,,c,d,\n1,2,3,4,5\nv,w,x,y,z");){
                CSVParser parser = format.parse((Reader)reader);
                Throwable throwable = null;
                if (parser != null) {
                    if (throwable != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        parser.close();
                    }
                }
            }
        }, (String)"2+ missing column headers is not allowed!");
    }
}

