/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv211Test {
    @Test
    public void testJiraCsv211Format() throws IOException {
        Object[] values = new String[]{"1", "Jane Doe", "USA", ""};
        CSVFormat printFormat = CSVFormat.DEFAULT.builder().setDelimiter('\t').setHeader(new String[]{"ID", "Name", "Country", "Age"}).build();
        String formatted = printFormat.format(values);
        Assertions.assertEquals((Object)"ID\tName\tCountry\tAge\r\n1\tJane Doe\tUSA\t", (Object)formatted);
        CSVFormat parseFormat = CSVFormat.DEFAULT.builder().setDelimiter('\t').setHeader(new String[0]).setSkipHeaderRecord(true).build();
        try (CSVParser parser = parseFormat.parse((Reader)new StringReader(formatted));){
            for (CSVRecord record : parser) {
                Assertions.assertEquals((Object)"1", (Object)record.get(0));
                Assertions.assertEquals((Object)"Jane Doe", (Object)record.get(1));
                Assertions.assertEquals((Object)"USA", (Object)record.get(2));
                Assertions.assertEquals((Object)"", (Object)record.get(3));
            }
        }
    }
}

