/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv149Test {
    private static final String CR_LF = "\r\n";

    @Test
    public void testJiraCsv149EndWithEOL() throws IOException {
        this.testJiraCsv149EndWithEolAtEof(true);
    }

    private void testJiraCsv149EndWithEolAtEof(boolean eolAtEof) throws IOException {
        String source = "A,B,C,D\r\na1,b1,c1,d1\r\na2,b2,c2,d2";
        if (eolAtEof) {
            source = source + CR_LF;
        }
        StringReader records = new StringReader(source);
        CSVFormat format = CSVFormat.RFC4180.builder().setHeader(new String[0]).setSkipHeaderRecord(true).setQuote('\"').build();
        int lineCounter = 2;
        try (CSVParser parser = new CSVParser((Reader)records, format);){
            for (CSVRecord record : parser) {
                Assertions.assertEquals((long)lineCounter++, (long)parser.getCurrentLineNumber());
            }
        }
    }

    @Test
    public void testJiraCsv149EndWithoutEOL() throws IOException {
        this.testJiraCsv149EndWithEolAtEof(false);
    }
}

