/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv164Test {
    @Test
    public void testJiraCsv154_withCommentMarker() throws IOException {
        String comment = "This is a header comment";
        CSVFormat format = CSVFormat.EXCEL.withHeader(new String[]{"H1", "H2"}).withCommentMarker('#').withHeaderComments(new Object[]{"This is a header comment"});
        StringBuilder out = new StringBuilder();
        try (CSVPrinter printer = format.print((Appendable)out);){
            printer.print((Object)"A");
            printer.print((Object)"B");
        }
        String s = out.toString();
        Assertions.assertTrue((boolean)s.contains("This is a header comment"), (String)s);
    }

    @Test
    public void testJiraCsv154_withHeaderComments() throws IOException {
        String comment = "This is a header comment";
        CSVFormat format = CSVFormat.EXCEL.withHeader(new String[]{"H1", "H2"}).withHeaderComments(new Object[]{"This is a header comment"}).withCommentMarker('#');
        StringBuilder out = new StringBuilder();
        try (CSVPrinter printer = format.print((Appendable)out);){
            printer.print((Object)"A");
            printer.print((Object)"B");
        }
        String s = out.toString();
        Assertions.assertTrue((boolean)s.contains("This is a header comment"), (String)s);
    }
}

