/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import org.apache.commons.csv.Token;
import org.apache.commons.csv.TokenMatchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TokenMatchersTest {
    private Token token;

    @BeforeEach
    public void setUp() {
        this.token = new Token();
        this.token.type = Token.Type.TOKEN;
        this.token.isReady = true;
        this.token.content.append("content");
    }

    @Test
    public void testHasType() {
        Assertions.assertFalse((boolean)TokenMatchers.hasType(Token.Type.COMMENT).matches((Object)this.token));
        Assertions.assertFalse((boolean)TokenMatchers.hasType(Token.Type.EOF).matches((Object)this.token));
        Assertions.assertFalse((boolean)TokenMatchers.hasType(Token.Type.EORECORD).matches((Object)this.token));
        Assertions.assertTrue((boolean)TokenMatchers.hasType(Token.Type.TOKEN).matches((Object)this.token));
    }

    @Test
    public void testHasContent() {
        Assertions.assertFalse((boolean)TokenMatchers.hasContent("This is not the token's content").matches((Object)this.token));
        Assertions.assertTrue((boolean)TokenMatchers.hasContent("content").matches((Object)this.token));
    }

    @Test
    public void testIsReady() {
        Assertions.assertTrue((boolean)TokenMatchers.isReady().matches((Object)this.token));
        this.token.isReady = false;
        Assertions.assertFalse((boolean)TokenMatchers.isReady().matches((Object)this.token));
    }

    @Test
    public void testMatches() {
        Assertions.assertTrue((boolean)TokenMatchers.matches(Token.Type.TOKEN, "content").matches((Object)this.token));
        Assertions.assertFalse((boolean)TokenMatchers.matches(Token.Type.EOF, "content").matches((Object)this.token));
        Assertions.assertFalse((boolean)TokenMatchers.matches(Token.Type.TOKEN, "not the content").matches((Object)this.token));
        Assertions.assertFalse((boolean)TokenMatchers.matches(Token.Type.EORECORD, "not the content").matches((Object)this.token));
    }
}

