/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.bugs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.junit.Assert;
import org.junit.Test;

public class JiraCsv167Test {
    @Test
    public void parse() throws IOException {
        BufferedReader br = new BufferedReader(this.getTestInput());
        String s = null;
        int totcomment = 0;
        int totrecs = 0;
        boolean lastWasComment = false;
        while ((s = br.readLine()) != null) {
            if (s.startsWith("#")) {
                if (!lastWasComment) {
                    ++totcomment;
                }
                lastWasComment = true;
                continue;
            }
            ++totrecs;
            lastWasComment = false;
        }
        br.close();
        CSVFormat format = CSVFormat.DEFAULT;
        format = format.withAllowMissingColumnNames(false);
        format = format.withCommentMarker('#');
        format = format.withDelimiter(',');
        format = format.withEscape('\\');
        format = format.withHeader(new String[]{"author", "title", "publishDate"});
        format = format.withHeaderComments(new Object[]{"headerComment"});
        format = format.withNullString("NULL");
        format = format.withIgnoreEmptyLines(true);
        format = format.withIgnoreSurroundingSpaces(true);
        format = format.withQuote('\"');
        format = format.withQuoteMode(QuoteMode.ALL);
        format = format.withRecordSeparator('\n');
        format = format.withSkipHeaderRecord(false);
        CSVParser parser = format.parse(this.getTestInput());
        int comments = 0;
        int records = 0;
        for (CSVRecord csvRecord : parser) {
            ++records;
            if (!csvRecord.hasComment()) continue;
            ++comments;
        }
        Assert.assertEquals((long)totcomment, (long)comments);
        Assert.assertEquals((long)totrecs, (long)records);
    }

    private Reader getTestInput() {
        InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream("csv-167/sample1.csv");
        return new InputStreamReader(is);
    }
}

