/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CSVRecordTest {
    private String[] values;
    private CSVRecord record;
    private CSVRecord recordWithHeader;
    private Map<String, Integer> header;

    @Before
    public void setUp() throws Exception {
        this.values = new String[]{"A", "B", "C"};
        this.record = new CSVRecord(this.values, null, null, 0L, -1L);
        this.header = new HashMap<String, Integer>();
        this.header.put("first", 0);
        this.header.put("second", 1);
        this.header.put("third", 2);
        this.recordWithHeader = new CSVRecord(this.values, this.header, null, 0L, -1L);
    }

    @Test
    public void testGetInt() {
        Assert.assertEquals((Object)this.values[0], (Object)this.record.get(0));
        Assert.assertEquals((Object)this.values[1], (Object)this.record.get(1));
        Assert.assertEquals((Object)this.values[2], (Object)this.record.get(2));
    }

    @Test
    public void testGetString() {
        Assert.assertEquals((Object)this.values[0], (Object)this.recordWithHeader.get("first"));
        Assert.assertEquals((Object)this.values[1], (Object)this.recordWithHeader.get("second"));
        Assert.assertEquals((Object)this.values[2], (Object)this.recordWithHeader.get("third"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetStringInconsistentRecord() {
        this.header.put("fourth", 4);
        this.recordWithHeader.get("fourth");
    }

    @Test(expected=IllegalStateException.class)
    public void testGetStringNoHeader() {
        this.record.get("first");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetUnmappedEnum() {
        Assert.assertNull((Object)this.recordWithHeader.get((Enum)EnumFixture.UNKNOWN_COLUMN));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetUnmappedName() {
        Assert.assertNull((Object)this.recordWithHeader.get("fourth"));
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testGetUnmappedNegativeInt() {
        Assert.assertNull((Object)this.recordWithHeader.get(Integer.MIN_VALUE));
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testGetUnmappedPositiveInt() {
        Assert.assertNull((Object)this.recordWithHeader.get(Integer.MAX_VALUE));
    }

    @Test
    public void testIsConsistent() {
        Assert.assertTrue((boolean)this.record.isConsistent());
        Assert.assertTrue((boolean)this.recordWithHeader.isConsistent());
        this.header.put("fourth", 4);
        Assert.assertFalse((boolean)this.recordWithHeader.isConsistent());
    }

    @Test
    public void testIsMapped() {
        Assert.assertFalse((boolean)this.record.isMapped("first"));
        Assert.assertTrue((boolean)this.recordWithHeader.isMapped("first"));
        Assert.assertFalse((boolean)this.recordWithHeader.isMapped("fourth"));
    }

    @Test
    public void testIsSet() {
        Assert.assertFalse((boolean)this.record.isSet("first"));
        Assert.assertTrue((boolean)this.recordWithHeader.isSet("first"));
        Assert.assertFalse((boolean)this.recordWithHeader.isSet("fourth"));
    }

    @Test
    public void testIterator() {
        int i = 0;
        for (String value : this.record) {
            Assert.assertEquals((Object)this.values[i], (Object)value);
            ++i;
        }
    }

    @Test
    public void testPutInMap() {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        this.recordWithHeader.putIn(map);
        this.validateMap(map, false);
        TreeMap map2 = (TreeMap)this.recordWithHeader.putIn(new TreeMap());
        this.validateMap(map2, false);
    }

    @Test
    public void testRemoveAndAddColumns() throws IOException {
        CSVPrinter printer = new CSVPrinter((Appendable)new StringBuilder(), CSVFormat.DEFAULT);
        Map map = this.recordWithHeader.toMap();
        map.remove("OldColumn");
        map.put("ZColumn", "NewValue");
        ArrayList list = new ArrayList(map.values());
        Collections.sort(list);
        printer.printRecord(list);
        Assert.assertEquals((Object)("A,B,C,NewValue" + CSVFormat.DEFAULT.getRecordSeparator()), (Object)printer.getOut().toString());
        printer.close();
    }

    @Test
    public void testToMap() {
        Map map = this.recordWithHeader.toMap();
        this.validateMap(map, true);
    }

    @Test
    public void testToMapWithShortRecord() throws Exception {
        CSVParser parser = CSVParser.parse((String)"a,b", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[]{"A", "B", "C"}));
        CSVRecord shortRec = (CSVRecord)parser.iterator().next();
        shortRec.toMap();
    }

    @Test
    public void testToMapWithNoHeader() throws Exception {
        CSVParser parser = CSVParser.parse((String)"a,b", (CSVFormat)CSVFormat.newFormat((char)','));
        CSVRecord shortRec = (CSVRecord)parser.iterator().next();
        Map map = shortRec.toMap();
        Assert.assertNotNull((String)"Map is not null.", (Object)map);
        Assert.assertTrue((String)"Map is empty.", (boolean)map.isEmpty());
    }

    private void validateMap(Map<String, String> map, boolean allowsNulls) {
        Assert.assertTrue((boolean)map.containsKey("first"));
        Assert.assertTrue((boolean)map.containsKey("second"));
        Assert.assertTrue((boolean)map.containsKey("third"));
        Assert.assertFalse((boolean)map.containsKey("fourth"));
        if (allowsNulls) {
            Assert.assertFalse((boolean)map.containsKey(null));
        }
        Assert.assertEquals((Object)"A", (Object)map.get("first"));
        Assert.assertEquals((Object)"B", (Object)map.get("second"));
        Assert.assertEquals((Object)"C", (Object)map.get("third"));
        Assert.assertEquals(null, (Object)map.get("fourth"));
    }

    private static enum EnumFixture {
        UNKNOWN_COLUMN;

    }
}

