/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.Utils;
import org.apache.commons.io.input.BOMInputStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CSVParserTest {
    private static final String CSV_INPUT = "a,b,c,d\n a , b , 1 2 \n\"foo baar\", b,\n   \"foo\n,,\n\"\",,\n\"\"\",d,e\n";
    private static final String CSV_INPUT_1 = "a,b,c,d";
    private static final String CSV_INPUT_2 = "a,b,1 2";
    private static final String[][] RESULT = new String[][]{{"a", "b", "c", "d"}, {"a", "b", "1 2"}, {"foo baar", "b", ""}, {"foo\n,,\n\",,\n\"", "d", "e"}};

    @Test
    public void testBackslashEscaping() throws IOException {
        String code = "one,two,three\n'',''\n/',/'\n'/'','/''\n'''',''''\n/,,/,\n//,//\n'//','//'\n   8   ,   \"quoted \"\" /\" // string\"   \n9,   /\n   \n";
        String[][] res = new String[][]{{"one", "two", "three"}, {"", ""}, {"'", "'"}, {"'", "'"}, {"'", "'"}, {",", ","}, {"/", "/"}, {"/", "/"}, {"   8   ", "   \"quoted \"\" /\" / string\"   "}, {"9", "   \n   "}};
        CSVFormat format = CSVFormat.newFormat((char)',').withQuote('\'').withRecordSeparator("\r\n").withEscape('/').withIgnoreEmptyLines();
        CSVParser parser = CSVParser.parse((String)"one,two,three\n'',''\n/',/'\n'/'','/''\n'''',''''\n/,,/,\n//,//\n'//','//'\n   8   ,   \"quoted \"\" /\" // string\"   \n9,   /\n   \n", (CSVFormat)format);
        List records = parser.getRecords();
        Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
        Utils.compare("Records do not match expected result", res, records);
        parser.close();
    }

    @Test
    public void testBackslashEscaping2() throws IOException {
        String code = " , , \n \t ,  , \n // , /, , /,\n";
        String[][] res = new String[][]{{" ", " ", " "}, {" \t ", "  ", " "}, {" / ", " , ", " ,"}};
        CSVFormat format = CSVFormat.newFormat((char)',').withRecordSeparator("\r\n").withEscape('/').withIgnoreEmptyLines();
        CSVParser parser = CSVParser.parse((String)" , , \n \t ,  , \n // , /, , /,\n", (CSVFormat)format);
        List records = parser.getRecords();
        Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
        Utils.compare("", res, records);
        parser.close();
    }

    @Test
    @Ignore
    public void testBackslashEscapingOld() throws IOException {
        String code = "one,two,three\non\\\"e,two\non\"e,two\none,\"tw\\\"o\"\none,\"t\\,wo\"\none,two,\"th,ree\"\n\"a\\\\\"\na\\,b\n\"a\\\\,b\"";
        String[][] res = new String[][]{{"one", "two", "three"}, {"on\\\"e", "two"}, {"on\"e", "two"}, {"one", "tw\"o"}, {"one", "t\\,wo"}, {"one", "two", "th,ree"}, {"a\\\\"}, {"a\\", "b"}, {"a\\\\,b"}};
        CSVParser parser = CSVParser.parse((String)"one,two,three\non\\\"e,two\non\"e,two\none,\"tw\\\"o\"\none,\"t\\,wo\"\none,two,\"th,ree\"\n\"a\\\\\"\na\\,b\n\"a\\\\,b\"", (CSVFormat)CSVFormat.DEFAULT);
        List records = parser.getRecords();
        Assert.assertEquals((long)res.length, (long)records.size());
        Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < res.length; ++i) {
            Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
        }
        parser.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="CSV-107")
    public void testBOM() throws IOException {
        URL url = ClassLoader.getSystemClassLoader().getResource("CSVFileParser/bom.csv");
        CSVParser parser = CSVParser.parse((URL)url, (Charset)Charset.forName("UTF-8"), (CSVFormat)CSVFormat.EXCEL.withHeader(new String[0]));
        try {
            for (CSVRecord record : parser) {
                String string = record.get("Date");
                Assert.assertNotNull((Object)string);
            }
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBOMInputStream() throws IOException {
        URL url = ClassLoader.getSystemClassLoader().getResource("CSVFileParser/bom.csv");
        InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(url.openStream()), "UTF-8");
        CSVParser parser = new CSVParser((Reader)reader, CSVFormat.EXCEL.withHeader(new String[0]));
        try {
            for (CSVRecord record : parser) {
                String string = record.get("Date");
                Assert.assertNotNull((Object)string);
            }
        }
        finally {
            parser.close();
            ((Reader)reader).close();
        }
    }

    @Test
    public void testCarriageReturnEndings() throws IOException {
        String code = "foo\rbaar,\rhello,world\r,kanu";
        CSVParser parser = CSVParser.parse((String)"foo\rbaar,\rhello,world\r,kanu", (CSVFormat)CSVFormat.DEFAULT);
        List records = parser.getRecords();
        Assert.assertEquals((long)4L, (long)records.size());
        parser.close();
    }

    @Test
    public void testCarriageReturnLineFeedEndings() throws IOException {
        String code = "foo\r\nbaar,\r\nhello,world\r\n,kanu";
        CSVParser parser = CSVParser.parse((String)"foo\r\nbaar,\r\nhello,world\r\n,kanu", (CSVFormat)CSVFormat.DEFAULT);
        List records = parser.getRecords();
        Assert.assertEquals((long)4L, (long)records.size());
        parser.close();
    }

    @Test(expected=NoSuchElementException.class)
    public void testClose() throws Exception {
        StringReader in = new StringReader("# comment\na,b,c\n1,2,3\nx,y,z");
        CSVParser parser = CSVFormat.DEFAULT.withCommentMarker('#').withHeader(new String[0]).parse((Reader)in);
        Iterator records = parser.iterator();
        Assert.assertTrue((boolean)records.hasNext());
        parser.close();
        Assert.assertFalse((boolean)records.hasNext());
        records.next();
    }

    @Test
    public void testCSV57() throws Exception {
        CSVParser parser = CSVParser.parse((String)"", (CSVFormat)CSVFormat.DEFAULT);
        List list = parser.getRecords();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)0L, (long)list.size());
        parser.close();
    }

    @Test
    public void testDefaultFormat() throws IOException {
        String code = "a,b#\n\"\n\",\" \",#\n#,\"\"\n# Final comment\n";
        String[][] res = new String[][]{{"a", "b#"}, {"\n", " ", "#"}, {"#", ""}, {"# Final comment"}};
        CSVFormat format = CSVFormat.DEFAULT;
        Assert.assertFalse((boolean)format.isCommentMarkerSet());
        CSVParser parser = CSVParser.parse((String)"a,b#\n\"\n\",\" \",#\n#,\"\"\n# Final comment\n", (CSVFormat)format);
        List records = parser.getRecords();
        Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
        Utils.compare("Failed to parse without comments", res, records);
        String[][] res_comments = new String[][]{{"a", "b#"}, {"\n", " ", "#"}};
        format = CSVFormat.DEFAULT.withCommentMarker('#');
        parser.close();
        parser = CSVParser.parse((String)"a,b#\n\"\n\",\" \",#\n#,\"\"\n# Final comment\n", (CSVFormat)format);
        records = parser.getRecords();
        Utils.compare("Failed to parse with comments", res_comments, records);
        parser.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDuplicateHeaders() throws Exception {
        CSVParser.parse((String)"a,b,a\n1,2,3\nx,y,z", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[0]));
    }

    @Test
    public void testEmptyFile() throws Exception {
        CSVParser parser = CSVParser.parse((String)"", (CSVFormat)CSVFormat.DEFAULT);
        Assert.assertNull((Object)parser.nextRecord());
        parser.close();
    }

    @Test
    public void testEmptyLineBehaviourCSV() throws Exception {
        String[] codes = new String[]{"hello,\r\n\r\n\r\n", "hello,\n\n\n", "hello,\"\"\r\n\r\n\r\n", "hello,\"\"\n\n\n"};
        String[][] res = new String[][]{{"hello", ""}};
        for (String code : codes) {
            CSVParser parser = CSVParser.parse((String)code, (CSVFormat)CSVFormat.DEFAULT);
            List records = parser.getRecords();
            Assert.assertEquals((long)res.length, (long)records.size());
            Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
            for (int i = 0; i < res.length; ++i) {
                Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
            }
            parser.close();
        }
    }

    @Test
    public void testEmptyLineBehaviourExcel() throws Exception {
        String[] codes = new String[]{"hello,\r\n\r\n\r\n", "hello,\n\n\n", "hello,\"\"\r\n\r\n\r\n", "hello,\"\"\n\n\n"};
        String[][] res = new String[][]{{"hello", ""}, {""}, {""}};
        for (String code : codes) {
            CSVParser parser = CSVParser.parse((String)code, (CSVFormat)CSVFormat.EXCEL);
            List records = parser.getRecords();
            Assert.assertEquals((long)res.length, (long)records.size());
            Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
            for (int i = 0; i < res.length; ++i) {
                Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
            }
            parser.close();
        }
    }

    @Test
    public void testEndOfFileBehaviorCSV() throws Exception {
        String[] codes = new String[]{"hello,\r\n\r\nworld,\r\n", "hello,\r\n\r\nworld,", "hello,\r\n\r\nworld,\"\"\r\n", "hello,\r\n\r\nworld,\"\"", "hello,\r\n\r\nworld,\n", "hello,\r\n\r\nworld,", "hello,\r\n\r\nworld,\"\"\n", "hello,\r\n\r\nworld,\"\""};
        String[][] res = new String[][]{{"hello", ""}, {"world", ""}};
        for (String code : codes) {
            CSVParser parser = CSVParser.parse((String)code, (CSVFormat)CSVFormat.DEFAULT);
            List records = parser.getRecords();
            Assert.assertEquals((long)res.length, (long)records.size());
            Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
            for (int i = 0; i < res.length; ++i) {
                Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
            }
            parser.close();
        }
    }

    @Test
    public void testEndOfFileBehaviourExcel() throws Exception {
        String[] codes = new String[]{"hello,\r\n\r\nworld,\r\n", "hello,\r\n\r\nworld,", "hello,\r\n\r\nworld,\"\"\r\n", "hello,\r\n\r\nworld,\"\"", "hello,\r\n\r\nworld,\n", "hello,\r\n\r\nworld,", "hello,\r\n\r\nworld,\"\"\n", "hello,\r\n\r\nworld,\"\""};
        String[][] res = new String[][]{{"hello", ""}, {""}, {"world", ""}};
        for (String code : codes) {
            CSVParser parser = CSVParser.parse((String)code, (CSVFormat)CSVFormat.EXCEL);
            List records = parser.getRecords();
            Assert.assertEquals((long)res.length, (long)records.size());
            Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
            for (int i = 0; i < res.length; ++i) {
                Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
            }
            parser.close();
        }
    }

    @Test
    public void testExcelFormat1() throws IOException {
        String code = "value1,value2,value3,value4\r\na,b,c,d\r\n  x,,,\r\n\r\n\"\"\"hello\"\"\",\"  \"\"world\"\"\",\"abc\ndef\",\r\n";
        String[][] res = new String[][]{{"value1", "value2", "value3", "value4"}, {"a", "b", "c", "d"}, {"  x", "", "", ""}, {""}, {"\"hello\"", "  \"world\"", "abc\ndef", ""}};
        CSVParser parser = CSVParser.parse((String)"value1,value2,value3,value4\r\na,b,c,d\r\n  x,,,\r\n\r\n\"\"\"hello\"\"\",\"  \"\"world\"\"\",\"abc\ndef\",\r\n", (CSVFormat)CSVFormat.EXCEL);
        List records = parser.getRecords();
        Assert.assertEquals((long)res.length, (long)records.size());
        Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < res.length; ++i) {
            Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
        }
        parser.close();
    }

    @Test
    public void testExcelFormat2() throws Exception {
        String code = "foo,baar\r\n\r\nhello,\r\n\r\nworld,\r\n";
        String[][] res = new String[][]{{"foo", "baar"}, {""}, {"hello", ""}, {""}, {"world", ""}};
        CSVParser parser = CSVParser.parse((String)"foo,baar\r\n\r\nhello,\r\n\r\nworld,\r\n", (CSVFormat)CSVFormat.EXCEL);
        List records = parser.getRecords();
        Assert.assertEquals((long)res.length, (long)records.size());
        Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < res.length; ++i) {
            Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
        }
        parser.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExcelHeaderCountLessThanData() throws Exception {
        String code = "A,B,C,,\r\na,b,c,d,e\r\n";
        CSVParser parser = CSVParser.parse((String)"A,B,C,,\r\na,b,c,d,e\r\n", (CSVFormat)CSVFormat.EXCEL.withHeader(new String[0]));
        try {
            for (CSVRecord record : parser.getRecords()) {
                Assert.assertEquals((Object)"a", (Object)record.get("A"));
                Assert.assertEquals((Object)"b", (Object)record.get("B"));
                Assert.assertEquals((Object)"c", (Object)record.get("C"));
            }
        }
        finally {
            parser.close();
        }
    }

    @Test
    public void testForEach() throws Exception {
        ArrayList<CSVRecord> records = new ArrayList<CSVRecord>();
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        for (CSVRecord record : CSVFormat.DEFAULT.parse((Reader)in)) {
            records.add(record);
        }
        Assert.assertEquals((long)3L, (long)records.size());
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])((CSVRecord)records.get(0)).values());
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])((CSVRecord)records.get(1)).values());
        Assert.assertArrayEquals((Object[])new String[]{"x", "y", "z"}, (Object[])((CSVRecord)records.get(2)).values());
    }

    @Test
    public void testGetHeaderMap() throws Exception {
        CSVParser parser = CSVParser.parse((String)"a,b,c\n1,2,3\nx,y,z", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[]{"A", "B", "C"}));
        Map headerMap = parser.getHeaderMap();
        Iterator columnNames = headerMap.keySet().iterator();
        Assert.assertEquals((Object)"A", columnNames.next());
        Assert.assertEquals((Object)"B", columnNames.next());
        Assert.assertEquals((Object)"C", columnNames.next());
        Iterator records = parser.iterator();
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)records.hasNext());
            CSVRecord record = (CSVRecord)records.next();
            Assert.assertEquals((Object)record.get(0), (Object)record.get("A"));
            Assert.assertEquals((Object)record.get(1), (Object)record.get("B"));
            Assert.assertEquals((Object)record.get(2), (Object)record.get("C"));
        }
        Assert.assertFalse((boolean)records.hasNext());
        parser.close();
    }

    @Test
    public void testGetLine() throws IOException {
        CSVParser parser = CSVParser.parse((String)CSV_INPUT, (CSVFormat)CSVFormat.DEFAULT.withIgnoreSurroundingSpaces());
        for (Object[] objectArray : RESULT) {
            Assert.assertArrayEquals((Object[])objectArray, (Object[])parser.nextRecord().values());
        }
        Assert.assertNull((Object)parser.nextRecord());
        parser.close();
    }

    @Test
    public void testGetLineNumberWithCR() throws Exception {
        this.validateLineNumbers(String.valueOf('\r'));
    }

    @Test
    public void testGetLineNumberWithCRLF() throws Exception {
        this.validateLineNumbers("\r\n");
    }

    @Test
    public void testGetLineNumberWithLF() throws Exception {
        this.validateLineNumbers(String.valueOf('\n'));
    }

    @Test
    public void testGetOneLine() throws IOException {
        CSVParser parser = CSVParser.parse((String)CSV_INPUT_1, (CSVFormat)CSVFormat.DEFAULT);
        CSVRecord record = (CSVRecord)parser.getRecords().get(0);
        Assert.assertArrayEquals((Object[])RESULT[0], (Object[])record.values());
        parser.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetOneLineOneParser() throws IOException {
        PipedWriter writer = new PipedWriter();
        PipedReader reader = new PipedReader(writer);
        CSVFormat format = CSVFormat.DEFAULT;
        CSVParser parser = new CSVParser((Reader)reader, format);
        try {
            writer.append(CSV_INPUT_1);
            writer.append(format.getRecordSeparator());
            CSVRecord record1 = parser.nextRecord();
            Assert.assertArrayEquals((Object[])RESULT[0], (Object[])record1.values());
            writer.append(CSV_INPUT_2);
            writer.append(format.getRecordSeparator());
            CSVRecord record2 = parser.nextRecord();
            Assert.assertArrayEquals((Object[])RESULT[1], (Object[])record2.values());
        }
        finally {
            parser.close();
        }
    }

    @Test
    public void testGetRecordNumberWithCR() throws Exception {
        this.validateRecordNumbers(String.valueOf('\r'));
    }

    @Test
    public void testGetRecordNumberWithCRLF() throws Exception {
        this.validateRecordNumbers("\r\n");
    }

    @Test
    public void testGetRecordNumberWithLF() throws Exception {
        this.validateRecordNumbers(String.valueOf('\n'));
    }

    @Test
    public void testGetRecordPositionWithCRLF() throws Exception {
        this.validateRecordPosition("\r\n");
    }

    @Test
    public void testGetRecordPositionWithLF() throws Exception {
        this.validateRecordPosition(String.valueOf('\n'));
    }

    @Test
    public void testGetRecords() throws IOException {
        CSVParser parser = CSVParser.parse((String)CSV_INPUT, (CSVFormat)CSVFormat.DEFAULT.withIgnoreSurroundingSpaces());
        List records = parser.getRecords();
        Assert.assertEquals((long)RESULT.length, (long)records.size());
        Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < RESULT.length; ++i) {
            Assert.assertArrayEquals((Object[])RESULT[i], (Object[])((CSVRecord)records.get(i)).values());
        }
        parser.close();
    }

    @Test
    public void testGetRecordWithMultiLineValues() throws Exception {
        CSVParser parser = CSVParser.parse((String)"\"a\r\n1\",\"a\r\n2\"\r\n\"b\r\n1\",\"b\r\n2\"\r\n\"c\r\n1\",\"c\r\n2\"", (CSVFormat)CSVFormat.DEFAULT.withRecordSeparator("\r\n"));
        Assert.assertEquals((long)0L, (long)parser.getRecordNumber());
        Assert.assertEquals((long)0L, (long)parser.getCurrentLineNumber());
        CSVRecord record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)3L, (long)parser.getCurrentLineNumber());
        Assert.assertEquals((long)1L, (long)record.getRecordNumber());
        Assert.assertEquals((long)1L, (long)parser.getRecordNumber());
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)6L, (long)parser.getCurrentLineNumber());
        Assert.assertEquals((long)2L, (long)record.getRecordNumber());
        Assert.assertEquals((long)2L, (long)parser.getRecordNumber());
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)8L, (long)parser.getCurrentLineNumber());
        Assert.assertEquals((long)3L, (long)record.getRecordNumber());
        Assert.assertEquals((long)3L, (long)parser.getRecordNumber());
        record = parser.nextRecord();
        Assert.assertNull((Object)record);
        Assert.assertEquals((long)8L, (long)parser.getCurrentLineNumber());
        Assert.assertEquals((long)3L, (long)parser.getRecordNumber());
        parser.close();
    }

    @Test
    public void testHeader() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[0]).parse((Reader)in).iterator();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)records.hasNext());
            CSVRecord record = (CSVRecord)records.next();
            Assert.assertEquals((Object)record.get(0), (Object)record.get("a"));
            Assert.assertEquals((Object)record.get(1), (Object)record.get("b"));
            Assert.assertEquals((Object)record.get(2), (Object)record.get("c"));
        }
        Assert.assertFalse((boolean)records.hasNext());
    }

    @Test
    public void testHeaderComment() throws Exception {
        StringReader in = new StringReader("# comment\na,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withCommentMarker('#').withHeader(new String[0]).parse((Reader)in).iterator();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)records.hasNext());
            CSVRecord record = (CSVRecord)records.next();
            Assert.assertEquals((Object)record.get(0), (Object)record.get("a"));
            Assert.assertEquals((Object)record.get(1), (Object)record.get("b"));
            Assert.assertEquals((Object)record.get(2), (Object)record.get("c"));
        }
        Assert.assertFalse((boolean)records.hasNext());
    }

    @Test
    public void testHeaderMissing() throws Exception {
        StringReader in = new StringReader("a,,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[0]).parse((Reader)in).iterator();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)records.hasNext());
            CSVRecord record = (CSVRecord)records.next();
            Assert.assertEquals((Object)record.get(0), (Object)record.get("a"));
            Assert.assertEquals((Object)record.get(2), (Object)record.get("c"));
        }
        Assert.assertFalse((boolean)records.hasNext());
    }

    @Test
    public void testHeaderMissingWithNull() throws Exception {
        StringReader in = new StringReader("a,,c,,d\n1,2,3,4\nx,y,z,zz");
        CSVFormat.DEFAULT.withHeader(new String[0]).withNullString("").withAllowMissingColumnNames().parse((Reader)in).iterator();
    }

    @Test
    public void testHeadersMissing() throws Exception {
        StringReader in = new StringReader("a,,c,,d\n1,2,3,4\nx,y,z,zz");
        CSVFormat.DEFAULT.withHeader(new String[0]).withAllowMissingColumnNames().parse((Reader)in).iterator();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testHeadersMissingException() throws Exception {
        StringReader in = new StringReader("a,,c,,d\n1,2,3,4\nx,y,z,zz");
        CSVFormat.DEFAULT.withHeader(new String[0]).parse((Reader)in).iterator();
    }

    @Test
    public void testIgnoreCaseHeaderMapping() throws Exception {
        StringReader in = new StringReader("1,2,3");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"One", "TWO", "three"}).withIgnoreHeaderCase().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("one"));
        Assert.assertEquals((Object)"2", (Object)record.get("two"));
        Assert.assertEquals((Object)"3", (Object)record.get("THREE"));
    }

    @Test
    public void testIgnoreEmptyLines() throws IOException {
        String code = "\nfoo,baar\n\r\n,\n\n,world\r\n\n";
        CSVParser parser = CSVParser.parse((String)"\nfoo,baar\n\r\n,\n\n,world\r\n\n", (CSVFormat)CSVFormat.DEFAULT);
        List records = parser.getRecords();
        Assert.assertEquals((long)3L, (long)records.size());
        parser.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidFormat() throws Exception {
        CSVFormat invalidFormat = CSVFormat.DEFAULT.withDelimiter('\r');
        new CSVParser(null, invalidFormat).close();
    }

    @Test
    public void testIterator() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator iterator = CSVFormat.DEFAULT.parse((Reader)in).iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        try {
            iterator.remove();
            Assert.fail((String)"expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])((CSVRecord)iterator.next()).values());
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])((CSVRecord)iterator.next()).values());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertArrayEquals((Object[])new String[]{"x", "y", "z"}, (Object[])((CSVRecord)iterator.next()).values());
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testLineFeedEndings() throws IOException {
        String code = "foo\nbaar,\nhello,world\n,kanu";
        CSVParser parser = CSVParser.parse((String)"foo\nbaar,\nhello,world\n,kanu", (CSVFormat)CSVFormat.DEFAULT);
        List records = parser.getRecords();
        Assert.assertEquals((long)4L, (long)records.size());
        parser.close();
    }

    @Test
    public void testMappedButNotSetAsOutlook2007ContactExport() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"A", "B", "C"}).withSkipHeaderRecord().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertTrue((boolean)record.isMapped("A"));
        Assert.assertTrue((boolean)record.isMapped("B"));
        Assert.assertTrue((boolean)record.isMapped("C"));
        Assert.assertTrue((boolean)record.isSet("A"));
        Assert.assertTrue((boolean)record.isSet("B"));
        Assert.assertFalse((boolean)record.isSet("C"));
        Assert.assertEquals((Object)"1", (Object)record.get("A"));
        Assert.assertEquals((Object)"2", (Object)record.get("B"));
        Assert.assertFalse((boolean)record.isConsistent());
        record = (CSVRecord)records.next();
        Assert.assertTrue((boolean)record.isMapped("A"));
        Assert.assertTrue((boolean)record.isMapped("B"));
        Assert.assertTrue((boolean)record.isMapped("C"));
        Assert.assertTrue((boolean)record.isSet("A"));
        Assert.assertTrue((boolean)record.isSet("B"));
        Assert.assertTrue((boolean)record.isSet("C"));
        Assert.assertEquals((Object)"x", (Object)record.get("A"));
        Assert.assertEquals((Object)"y", (Object)record.get("B"));
        Assert.assertEquals((Object)"z", (Object)record.get("C"));
        Assert.assertTrue((boolean)record.isConsistent());
        Assert.assertFalse((boolean)records.hasNext());
    }

    @Test
    public void testMultipleIterators() throws Exception {
        CSVParser parser = CSVParser.parse((String)"a,b,c\rd,e,f", (CSVFormat)CSVFormat.DEFAULT);
        Iterator itr1 = parser.iterator();
        Iterator itr2 = parser.iterator();
        CSVRecord first = (CSVRecord)itr1.next();
        Assert.assertEquals((Object)"a", (Object)first.get(0));
        Assert.assertEquals((Object)"b", (Object)first.get(1));
        Assert.assertEquals((Object)"c", (Object)first.get(2));
        CSVRecord second = (CSVRecord)itr2.next();
        Assert.assertEquals((Object)"d", (Object)second.get(0));
        Assert.assertEquals((Object)"e", (Object)second.get(1));
        Assert.assertEquals((Object)"f", (Object)second.get(2));
        parser.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNewCSVParserNullReaderFormat() throws Exception {
        new CSVParser(null, CSVFormat.DEFAULT).close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNewCSVParserReaderNullFormat() throws Exception {
        new CSVParser((Reader)new StringReader(""), null).close();
    }

    @Test
    public void testNoHeaderMap() throws Exception {
        CSVParser parser = CSVParser.parse((String)"a,b,c\n1,2,3\nx,y,z", (CSVFormat)CSVFormat.DEFAULT);
        Assert.assertNull((Object)parser.getHeaderMap());
        parser.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseFileNullFormat() throws Exception {
        CSVParser.parse((File)new File(""), (Charset)Charset.defaultCharset(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNullFileFormat() throws Exception {
        CSVParser.parse((File)null, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNullStringFormat() throws Exception {
        CSVParser.parse((String)null, (CSVFormat)CSVFormat.DEFAULT);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNullUrlCharsetFormat() throws Exception {
        CSVParser.parse((File)null, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParserUrlNullCharsetFormat() throws Exception {
        CSVParser parser = CSVParser.parse((URL)new URL("http://commons.apache.org"), null, (CSVFormat)CSVFormat.DEFAULT);
        parser.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseStringNullFormat() throws Exception {
        CSVParser.parse((String)"csv data", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseUrlCharsetNullFormat() throws Exception {
        CSVParser parser = CSVParser.parse((URL)new URL("http://commons.apache.org"), (Charset)Charset.defaultCharset(), null);
        parser.close();
    }

    @Test
    public void testProvidedHeader() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"A", "B", "C"}).parse((Reader)in).iterator();
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)records.hasNext());
            CSVRecord record = (CSVRecord)records.next();
            Assert.assertTrue((boolean)record.isMapped("A"));
            Assert.assertTrue((boolean)record.isMapped("B"));
            Assert.assertTrue((boolean)record.isMapped("C"));
            Assert.assertFalse((boolean)record.isMapped("NOT MAPPED"));
            Assert.assertEquals((Object)record.get(0), (Object)record.get("A"));
            Assert.assertEquals((Object)record.get(1), (Object)record.get("B"));
            Assert.assertEquals((Object)record.get(2), (Object)record.get("C"));
        }
        Assert.assertFalse((boolean)records.hasNext());
    }

    @Test
    public void testProvidedHeaderAuto() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[0]).parse((Reader)in).iterator();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((boolean)records.hasNext());
            CSVRecord record = (CSVRecord)records.next();
            Assert.assertTrue((boolean)record.isMapped("a"));
            Assert.assertTrue((boolean)record.isMapped("b"));
            Assert.assertTrue((boolean)record.isMapped("c"));
            Assert.assertFalse((boolean)record.isMapped("NOT MAPPED"));
            Assert.assertEquals((Object)record.get(0), (Object)record.get("a"));
            Assert.assertEquals((Object)record.get(1), (Object)record.get("b"));
            Assert.assertEquals((Object)record.get(2), (Object)record.get("c"));
        }
        Assert.assertFalse((boolean)records.hasNext());
    }

    @Test
    public void testRoundtrip() throws Exception {
        StringWriter out = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)out, CSVFormat.DEFAULT);
        String input = "a,b,c\r\n1,2,3\r\nx,y,z\r\n";
        for (CSVRecord record : CSVParser.parse((String)"a,b,c\r\n1,2,3\r\nx,y,z\r\n", (CSVFormat)CSVFormat.DEFAULT)) {
            printer.printRecord((Iterable)record);
        }
        Assert.assertEquals((Object)"a,b,c\r\n1,2,3\r\nx,y,z\r\n", (Object)out.toString());
        printer.close();
    }

    @Test
    public void testSkipAutoHeader() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[0]).parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("a"));
        Assert.assertEquals((Object)"2", (Object)record.get("b"));
        Assert.assertEquals((Object)"3", (Object)record.get("c"));
    }

    @Test
    public void testSkipHeaderOverrideDuplicateHeaders() throws Exception {
        StringReader in = new StringReader("a,a,a\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"X", "Y", "Z"}).withSkipHeaderRecord().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("X"));
        Assert.assertEquals((Object)"2", (Object)record.get("Y"));
        Assert.assertEquals((Object)"3", (Object)record.get("Z"));
    }

    @Test
    public void testSkipSetAltHeaders() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"X", "Y", "Z"}).withSkipHeaderRecord().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("X"));
        Assert.assertEquals((Object)"2", (Object)record.get("Y"));
        Assert.assertEquals((Object)"3", (Object)record.get("Z"));
    }

    @Test
    public void testSkipSetHeader() throws Exception {
        StringReader in = new StringReader("a,b,c\n1,2,3\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"a", "b", "c"}).withSkipHeaderRecord().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("a"));
        Assert.assertEquals((Object)"2", (Object)record.get("b"));
        Assert.assertEquals((Object)"3", (Object)record.get("c"));
    }

    @Test
    @Ignore
    public void testStartWithEmptyLinesThenHeaders() throws Exception {
        String[] codes = new String[]{"\r\n\r\n\r\nhello,\r\n\r\n\r\n", "hello,\n\n\n", "hello,\"\"\r\n\r\n\r\n", "hello,\"\"\n\n\n"};
        String[][] res = new String[][]{{"hello", ""}, {""}, {""}};
        for (String code : codes) {
            CSVParser parser = CSVParser.parse((String)code, (CSVFormat)CSVFormat.EXCEL);
            List records = parser.getRecords();
            Assert.assertEquals((long)res.length, (long)records.size());
            Assert.assertTrue((records.size() > 0 ? 1 : 0) != 0);
            for (int i = 0; i < res.length; ++i) {
                Assert.assertArrayEquals((Object[])res[i], (Object[])((CSVRecord)records.get(i)).values());
            }
            parser.close();
        }
    }

    @Test
    public void testTrailingDelimiter() throws Exception {
        StringReader in = new StringReader("a,a,a,\n\"1\",\"2\",\"3\",\nx,y,z,");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"X", "Y", "Z"}).withSkipHeaderRecord().withTrailingDelimiter().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("X"));
        Assert.assertEquals((Object)"2", (Object)record.get("Y"));
        Assert.assertEquals((Object)"3", (Object)record.get("Z"));
        Assert.assertEquals((long)3L, (long)record.size());
    }

    @Test
    public void testTrim() throws Exception {
        StringReader in = new StringReader("a,a,a\n\" 1 \",\" 2 \",\" 3 \"\nx,y,z");
        Iterator records = CSVFormat.DEFAULT.withHeader(new String[]{"X", "Y", "Z"}).withSkipHeaderRecord().withTrim().parse((Reader)in).iterator();
        CSVRecord record = (CSVRecord)records.next();
        Assert.assertEquals((Object)"1", (Object)record.get("X"));
        Assert.assertEquals((Object)"2", (Object)record.get("Y"));
        Assert.assertEquals((Object)"3", (Object)record.get("Z"));
        Assert.assertEquals((long)3L, (long)record.size());
    }

    private void validateLineNumbers(String lineSeparator) throws IOException {
        CSVParser parser = CSVParser.parse((String)("a" + lineSeparator + "b" + lineSeparator + "c"), (CSVFormat)CSVFormat.DEFAULT.withRecordSeparator(lineSeparator));
        Assert.assertEquals((long)0L, (long)parser.getCurrentLineNumber());
        Assert.assertNotNull((Object)parser.nextRecord());
        Assert.assertEquals((long)1L, (long)parser.getCurrentLineNumber());
        Assert.assertNotNull((Object)parser.nextRecord());
        Assert.assertEquals((long)2L, (long)parser.getCurrentLineNumber());
        Assert.assertNotNull((Object)parser.nextRecord());
        Assert.assertEquals((long)2L, (long)parser.getCurrentLineNumber());
        Assert.assertNull((Object)parser.nextRecord());
        Assert.assertEquals((long)2L, (long)parser.getCurrentLineNumber());
        parser.close();
    }

    private void validateRecordNumbers(String lineSeparator) throws IOException {
        CSVParser parser = CSVParser.parse((String)("a" + lineSeparator + "b" + lineSeparator + "c"), (CSVFormat)CSVFormat.DEFAULT.withRecordSeparator(lineSeparator));
        Assert.assertEquals((long)0L, (long)parser.getRecordNumber());
        CSVRecord record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)1L, (long)record.getRecordNumber());
        Assert.assertEquals((long)1L, (long)parser.getRecordNumber());
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)2L, (long)record.getRecordNumber());
        Assert.assertEquals((long)2L, (long)parser.getRecordNumber());
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)3L, (long)record.getRecordNumber());
        Assert.assertEquals((long)3L, (long)parser.getRecordNumber());
        record = parser.nextRecord();
        Assert.assertNull((Object)record);
        Assert.assertEquals((long)3L, (long)parser.getRecordNumber());
        parser.close();
    }

    private void validateRecordPosition(String lineSeparator) throws IOException {
        String nl = lineSeparator;
        String code = "a,b,c" + lineSeparator + "1,2,3" + lineSeparator + "'A" + nl + "A','B" + nl + "B',CC" + lineSeparator + "\u00c4,\u00d6,\u00dc" + lineSeparator + "EOF,EOF,EOF";
        CSVFormat format = CSVFormat.newFormat((char)',').withQuote('\'').withRecordSeparator(lineSeparator);
        CSVParser parser = CSVParser.parse((String)code, (CSVFormat)format);
        Assert.assertEquals((long)0L, (long)parser.getRecordNumber());
        CSVRecord record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)1L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf(97), (long)record.getCharacterPosition());
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)2L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf(49), (long)record.getCharacterPosition());
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        long positionRecord3 = record.getCharacterPosition();
        Assert.assertEquals((long)3L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf("'A"), (long)record.getCharacterPosition());
        Assert.assertEquals((Object)("A" + lineSeparator + "A"), (Object)record.get(0));
        Assert.assertEquals((Object)("B" + lineSeparator + "B"), (Object)record.get(1));
        Assert.assertEquals((Object)"CC", (Object)record.get(2));
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)4L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf(196), (long)record.getCharacterPosition());
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)5L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf("EOF"), (long)record.getCharacterPosition());
        parser.close();
        parser = new CSVParser((Reader)new StringReader(code.substring((int)positionRecord3)), format, positionRecord3, 3L);
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)3L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf("'A"), (long)record.getCharacterPosition());
        Assert.assertEquals((Object)("A" + lineSeparator + "A"), (Object)record.get(0));
        Assert.assertEquals((Object)("B" + lineSeparator + "B"), (Object)record.get(1));
        Assert.assertEquals((Object)"CC", (Object)record.get(2));
        record = parser.nextRecord();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)4L, (long)record.getRecordNumber());
        Assert.assertEquals((long)code.indexOf(196), (long)record.getCharacterPosition());
        Assert.assertEquals((Object)"\u00c4", (Object)record.get(0));
        parser.close();
    }
}

