/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.zip.GZIPInputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.ExtendedBufferedReader;
import org.apache.commons.csv.Lexer;
import org.apache.commons.csv.Token;
import org.apache.commons.io.IOUtils;

public class PerformanceTest {
    private static final String[] PROPS = new String[]{"java.version", "java.vendor", "java.vm.version", "java.vm.name", "os.name", "os.arch", "os.version"};
    private static int max = 10;
    private static int num = 0;
    private static long[] elapsedTimes = new long[max];
    private static final CSVFormat format = CSVFormat.EXCEL;
    private static final File BIG_FILE = new File(System.getProperty("java.io.tmpdir"), "worldcitiespop.txt");

    public static void main(String[] args) throws Exception {
        String[] tests;
        if (BIG_FILE.exists()) {
            System.out.println(String.format("Found test fixture %s: %,d bytes.", BIG_FILE, BIG_FILE.length()));
        } else {
            System.out.println("Decompressing test fixture " + BIG_FILE + "...");
            GZIPInputStream input = new GZIPInputStream(new FileInputStream("src/test/resources/perf/worldcitiespop.txt.gz"));
            FileOutputStream output = new FileOutputStream(BIG_FILE);
            IOUtils.copy((InputStream)input, (OutputStream)output);
            ((InputStream)input).close();
            ((OutputStream)output).close();
            System.out.println(String.format("Decompressed test fixture %s: %,d bytes.", BIG_FILE, BIG_FILE.length()));
        }
        int argc = args.length;
        if (argc > 0) {
            max = Integer.parseInt(args[0]);
        }
        if (argc > 1) {
            tests = new String[argc - 1];
            for (int i = 1; i < argc; ++i) {
                tests[i - 1] = args[i];
            }
        } else {
            tests = new String[]{"file", "split", "extb", "exts", "csv", "lexreset", "lexnew"};
        }
        for (String p : PROPS) {
            System.out.println(p + "=" + System.getProperty(p));
        }
        System.out.println("Max count: " + max + "\n");
        for (String test : tests) {
            if ("file".equals(test)) {
                PerformanceTest.testReadBigFile(false);
                continue;
            }
            if ("split".equals(test)) {
                PerformanceTest.testReadBigFile(true);
                continue;
            }
            if ("csv".equals(test)) {
                PerformanceTest.testParseCommonsCSV();
                continue;
            }
            if ("lexreset".equals(test)) {
                PerformanceTest.testCSVLexer(false, test);
                continue;
            }
            if ("lexnew".equals(test)) {
                PerformanceTest.testCSVLexer(true, test);
                continue;
            }
            if (test.startsWith("CSVLexer")) {
                PerformanceTest.testCSVLexer(false, test);
                continue;
            }
            if ("extb".equals(test)) {
                PerformanceTest.testExtendedBuffer(false);
                continue;
            }
            if ("exts".equals(test)) {
                PerformanceTest.testExtendedBuffer(true);
                continue;
            }
            System.out.println("Invalid test name: " + test);
        }
    }

    private static BufferedReader getReader() throws IOException {
        return new BufferedReader(new FileReader(BIG_FILE));
    }

    private static void show(String msg, Stats s, long start) {
        long elapsed = System.currentTimeMillis() - start;
        System.out.printf("%-20s: %5dms " + s.count + " lines " + s.fields + " fields%n", msg, elapsed);
        PerformanceTest.elapsedTimes[PerformanceTest.num++] = elapsed;
    }

    private static void show() {
        long tot = 0L;
        if (num > 1) {
            for (int i = 1; i < num; ++i) {
                tot += elapsedTimes[i];
            }
            System.out.printf("%-20s: %5dms%n%n", "Average(not first)", tot / (long)(num - 1));
        }
        num = 0;
    }

    private static void testReadBigFile(boolean split) throws Exception {
        for (int i = 0; i < max; ++i) {
            BufferedReader in = PerformanceTest.getReader();
            long t0 = System.currentTimeMillis();
            Stats s = PerformanceTest.readAll(in, split);
            in.close();
            PerformanceTest.show(split ? "file+split" : "file", s, t0);
        }
        PerformanceTest.show();
    }

    private static Stats readAll(BufferedReader in, boolean split) throws IOException {
        String record;
        int count = 0;
        int fields = 0;
        while ((record = in.readLine()) != null) {
            ++count;
            fields += split ? record.split(",").length : 1;
        }
        return new Stats(count, fields);
    }

    private static void testExtendedBuffer(boolean makeString) throws Exception {
        for (int i = 0; i < max; ++i) {
            int read;
            ExtendedBufferedReader in = new ExtendedBufferedReader((Reader)PerformanceTest.getReader());
            long t0 = System.currentTimeMillis();
            int fields = 0;
            int lines = 0;
            if (makeString) {
                StringBuilder sb = new StringBuilder();
                while ((read = in.read()) != -1) {
                    sb.append((char)read);
                    if (read == 44) {
                        sb.toString();
                        sb = new StringBuilder();
                        ++fields;
                        continue;
                    }
                    if (read != 10) continue;
                    sb.toString();
                    sb = new StringBuilder();
                    ++lines;
                }
            } else {
                while ((read = in.read()) != -1) {
                    if (read == 44) {
                        ++fields;
                        continue;
                    }
                    if (read != 10) continue;
                    ++lines;
                }
            }
            in.close();
            PerformanceTest.show("Extended" + (makeString ? " toString" : ""), new Stats(lines, fields += lines), t0);
        }
        PerformanceTest.show();
    }

    private static void testParseCommonsCSV() throws Exception {
        for (int i = 0; i < max; ++i) {
            BufferedReader reader = PerformanceTest.getReader();
            CSVParser parser = new CSVParser((Reader)reader, format);
            long t0 = System.currentTimeMillis();
            Stats s = PerformanceTest.iterate((Iterable<CSVRecord>)parser);
            reader.close();
            PerformanceTest.show("CSV", s, t0);
            parser.close();
        }
        PerformanceTest.show();
    }

    private static Constructor<Lexer> getLexerCtor(String clazz) throws Exception {
        Class<?> lexer = Class.forName("org.apache.commons.csv." + clazz);
        return lexer.getConstructor(CSVFormat.class, ExtendedBufferedReader.class);
    }

    private static void testCSVLexer(boolean newToken, String test) throws Exception {
        Token token = new Token();
        String dynamic = "";
        for (int i = 0; i < max; ++i) {
            ExtendedBufferedReader input = new ExtendedBufferedReader((Reader)PerformanceTest.getReader());
            Lexer lexer = null;
            if (test.startsWith("CSVLexer")) {
                dynamic = "!";
                lexer = PerformanceTest.getLexerCtor(test).newInstance(format, input);
            } else {
                lexer = new Lexer(format, input);
            }
            int count = 0;
            int fields = 0;
            long t0 = System.currentTimeMillis();
            do {
                if (newToken) {
                    token = new Token();
                } else {
                    token.reset();
                }
                lexer.nextToken(token);
                switch (token.type) {
                    case EOF: {
                        break;
                    }
                    case EORECORD: {
                        ++fields;
                        ++count;
                        break;
                    }
                    case INVALID: {
                        throw new IOException("invalid parse sequence <" + token.content.toString() + ">");
                    }
                    case TOKEN: {
                        ++fields;
                        break;
                    }
                    case COMMENT: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected Token type: " + token.type);
                    }
                }
            } while (!token.type.equals((Object)Token.Type.EOF));
            Stats s = new Stats(count, fields);
            input.close();
            PerformanceTest.show(lexer.getClass().getSimpleName() + dynamic + " " + (newToken ? "new" : "reset"), s, t0);
        }
        PerformanceTest.show();
    }

    private static Stats iterate(Iterable<CSVRecord> it) {
        int count = 0;
        int fields = 0;
        for (CSVRecord record : it) {
            ++count;
            fields += record.size();
        }
        return new Stats(count, fields);
    }

    private static class Stats {
        final int count;
        final int fields;

        Stats(int c, int f) {
            this.count = c;
            this.fields = f;
        }
    }
}

