/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv263Test {
    @Test
    public void testPrintFromReaderWithQuotes() throws IOException {
        CSVFormat format = CSVFormat.RFC4180.builder().setDelimiter(',').setQuote('\"').setEscape('?').setQuoteMode(QuoteMode.NON_NUMERIC).get();
        StringBuilder out = new StringBuilder();
        StringReader atStartOnly = new StringReader("\"a,b,c\r\nx,y,z");
        format.print((Object)atStartOnly, (Appendable)out, true);
        Assertions.assertEquals((Object)"\"\"\"a,b,c\r\nx,y,z\"", (Object)out.toString());
        StringReader atEndOnly = new StringReader("a,b,c\r\nx,y,z\"");
        out.setLength(0);
        format.print((Object)atEndOnly, (Appendable)out, true);
        Assertions.assertEquals((Object)"\"a,b,c\r\nx,y,z\"\"\"", (Object)out.toString());
        StringReader atBeginEnd = new StringReader("\"a,b,c\r\nx,y,z\"");
        out.setLength(0);
        format.print((Object)atBeginEnd, (Appendable)out, true);
        Assertions.assertEquals((Object)"\"\"\"a,b,c\r\nx,y,z\"\"\"", (Object)out.toString());
        StringReader embeddedBeginMiddle = new StringReader("\"a\",b,c\r\nx,\"y\",z");
        out.setLength(0);
        format.print((Object)embeddedBeginMiddle, (Appendable)out, true);
        Assertions.assertEquals((Object)"\"\"\"a\"\",b,c\r\nx,\"\"y\"\",z\"", (Object)out.toString());
        StringReader embeddedMiddleEnd = new StringReader("a,\"b\",c\r\nx,y,\"z\"");
        out.setLength(0);
        format.print((Object)embeddedMiddleEnd, (Appendable)out, true);
        Assertions.assertEquals((Object)"\"a,\"\"b\"\",c\r\nx,y,\"\"z\"\"\"", (Object)out.toString());
        StringReader nested = new StringReader("a,\"b \"and\" c\",d");
        out.setLength(0);
        format.print((Object)nested, (Appendable)out, true);
        Assertions.assertEquals((Object)"\"a,\"\"b \"\"and\"\" c\"\",d\"", (Object)out.toString());
    }
}

