/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv253Test {
    private void assertArrayEqual(String[] expected, CSVRecord actual) {
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)actual.get(i));
        }
    }

    @Test
    public void testHandleAbsentValues() throws IOException {
        String source = "\"John\",,\"Doe\"\n,\"AA\",123\n\"John\",90,\n\"\",,90";
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setQuoteMode(QuoteMode.NON_NUMERIC).get();
        try (CSVParser parser = csvFormat.parse((Reader)new StringReader("\"John\",,\"Doe\"\n,\"AA\",123\n\"John\",90,\n\"\",,90"));){
            Iterator csvRecords = parser.iterator();
            this.assertArrayEqual(new String[]{"John", null, "Doe"}, (CSVRecord)csvRecords.next());
            this.assertArrayEqual(new String[]{null, "AA", "123"}, (CSVRecord)csvRecords.next());
            this.assertArrayEqual(new String[]{"John", "90", null}, (CSVRecord)csvRecords.next());
            this.assertArrayEqual(new String[]{"", null, "90"}, (CSVRecord)csvRecords.next());
        }
    }
}

