/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv249Test {
    @Test
    public void testJiraCsv249() throws IOException {
        List records;
        CSVFormat format = CSVFormat.DEFAULT.builder().setEscape('\\').get();
        StringWriter stringWriter = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)stringWriter, format);){
            printer.printRecord(new Object[]{"foo \\", "bar"});
        }
        StringReader reader = new StringReader(stringWriter.toString());
        try (CSVParser parser = ((CSVParser.Builder)CSVParser.builder().setReader((Reader)reader)).setFormat(format).get();){
            records = parser.getRecords();
        }
        records.forEach(record -> {
            Assertions.assertEquals((Object)"foo \\", (Object)record.get(0));
            Assertions.assertEquals((Object)"bar", (Object)record.get(1));
        });
    }
}

