/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv206Test {
    @Test
    public void testJiraCsv206MultipleCharacterDelimiter() throws IOException {
        String source = "FirstName[|]LastName[|]Address\r\nJohn[|]Smith[|]123 Main St.";
        StringReader reader = new StringReader("FirstName[|]LastName[|]Address\r\nJohn[|]Smith[|]123 Main St.");
        CSVFormat format = CSVFormat.DEFAULT.builder().setDelimiter("[|]").get();
        CSVRecord record = null;
        try (CSVParser csvParser = ((CSVParser.Builder)CSVParser.builder().setReader((Reader)reader)).setFormat(format).get();){
            Iterator iterator = csvParser.iterator();
            record = (CSVRecord)iterator.next();
            Assertions.assertEquals((Object)"FirstName", (Object)record.get(0));
            Assertions.assertEquals((Object)"LastName", (Object)record.get(1));
            Assertions.assertEquals((Object)"Address", (Object)record.get(2));
            record = (CSVRecord)iterator.next();
            Assertions.assertEquals((Object)"John", (Object)record.get(0));
            Assertions.assertEquals((Object)"Smith", (Object)record.get(1));
            Assertions.assertEquals((Object)"123 Main St.", (Object)record.get(2));
        }
        String outString = "# Change delimiter to [I]\r\nfirst name[I]last name[I]address\r\nJohn[I]Smith[I]123 Main St.";
        String comment = "Change delimiter to [I]";
        CSVFormat formatExcel = CSVFormat.EXCEL.builder().setDelimiter("[I]").setHeader(new String[]{"first name", "last name", "address"}).setCommentMarker('#').setHeaderComments(new String[]{"Change delimiter to [I]"}).get();
        StringBuilder out = new StringBuilder();
        try (CSVPrinter printer = formatExcel.print((Appendable)out);){
            printer.print((Object)record.get(0));
            printer.print((Object)record.get(1));
            printer.print((Object)record.get(2));
        }
        String s = out.toString();
        Assertions.assertEquals((Object)"# Change delimiter to [I]\r\nfirst name[I]last name[I]address\r\nJohn[I]Smith[I]123 Main St.", (Object)s);
    }
}

