/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.Utils;
import org.apache.commons.io.input.BOMInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class UserGuideTest {
    @TempDir
    Path tempDir;

    public InputStreamReader newReader(Path path) throws IOException {
        return new InputStreamReader((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setPath(path)).get(), StandardCharsets.UTF_8);
    }

    @Test
    public void testBomFull() throws UnsupportedEncodingException, IOException {
        Path path = this.tempDir.resolve("test1.csv");
        Files.copy(Utils.createUtf8Input("ColumnA, ColumnB, ColumnC\r\nA, B, C\r\n".getBytes(StandardCharsets.UTF_8), true), path, new CopyOption[0]);
        try (InputStreamReader reader = new InputStreamReader((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setPath(path)).get(), "UTF-8");
             CSVParser parser = CSVFormat.EXCEL.builder().setHeader(new String[0]).get().parse((Reader)reader);){
            for (CSVRecord record : parser) {
                String string = record.get("ColumnA");
                Assertions.assertEquals((Object)"A", (Object)string);
            }
        }
    }

    @Test
    public void testBomUtil() throws UnsupportedEncodingException, IOException {
        Path path = this.tempDir.resolve("test2.csv");
        Files.copy(Utils.createUtf8Input("ColumnA, ColumnB, ColumnC\r\nA, B, C\r\n".getBytes(StandardCharsets.UTF_8), true), path, new CopyOption[0]);
        try (InputStreamReader reader = this.newReader(path);
             CSVParser parser = CSVFormat.EXCEL.builder().setHeader(new String[0]).get().parse((Reader)reader);){
            for (CSVRecord record : parser) {
                String string = record.get("ColumnA");
                Assertions.assertEquals((Object)"A", (Object)string);
            }
        }
    }
}

