/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv196Test {
    private Reader getTestInput(String path) {
        return new InputStreamReader(ClassLoader.getSystemClassLoader().getResourceAsStream(path));
    }

    @Test
    public void testParseFourBytes() throws IOException {
        CSVFormat format = CSVFormat.Builder.create().setDelimiter(',').setQuote('\'').get();
        try (CSVParser parser = ((CSVParser.Builder)((CSVParser.Builder)new CSVParser.Builder().setFormat(format).setReader(this.getTestInput("org/apache/commons/csv/CSV-196/emoji.csv"))).setCharset(StandardCharsets.UTF_8)).setTrackBytes(true).get();){
            long[] charByteKey = new long[]{0L, 84L, 701L, 1318L, 1935L};
            int idx = 0;
            for (CSVRecord record : parser) {
                Assertions.assertEquals((long)charByteKey[idx++], (long)record.getBytePosition(), (String)("index " + idx));
            }
        }
    }

    @Test
    public void testParseThreeBytes() throws IOException {
        CSVFormat format = CSVFormat.Builder.create().setDelimiter(',').setQuote('\'').get();
        try (CSVParser parser = ((CSVParser.Builder)((CSVParser.Builder)new CSVParser.Builder().setFormat(format).setReader(this.getTestInput("org/apache/commons/csv/CSV-196/japanese.csv"))).setCharset(StandardCharsets.UTF_8)).setTrackBytes(true).get();){
            long[] charByteKey = new long[]{0L, 89L, 242L, 395L};
            int idx = 0;
            for (CSVRecord record : parser) {
                Assertions.assertEquals((long)charByteKey[idx++], (long)record.getBytePosition(), (String)("index " + idx));
            }
        }
    }
}

