/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class CSVRecordTest {
    private Map<String, Integer> headerMap;
    private CSVRecord record;
    private CSVRecord recordWithHeader;
    private String[] values;

    @BeforeEach
    public void setUp() throws Exception {
        this.values = new String[]{"A", "B", "C"};
        String rowData = StringUtils.join((Object[])this.values, (char)',');
        try (CSVParser parser = CSVFormat.DEFAULT.parse((Reader)new StringReader(rowData));){
            this.record = (CSVRecord)parser.iterator().next();
        }
        parser = CSVFormat.DEFAULT.builder().setHeader(EnumHeader.class).build().parse((Reader)new StringReader(rowData));
        try {
            this.recordWithHeader = (CSVRecord)parser.iterator().next();
            this.headerMap = parser.getHeaderMap();
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    @Test
    public void testCSVRecordNULLValues() throws IOException {
        try (CSVParser parser = CSVParser.parse((String)"A,B\r\nONE,TWO", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[0]));){
            CSVRecord csvRecord = new CSVRecord(parser, null, null, 0L, 0L);
            Assertions.assertEquals((int)0, (int)csvRecord.size());
            Assertions.assertThrows(IllegalArgumentException.class, () -> csvRecord.get("B"));
        }
    }

    @Test
    public void testDuplicateHeaderGet() throws IOException {
        String csv = "A,A,B,B\n1,2,5,6\n";
        CSVFormat format = CSVFormat.DEFAULT.builder().setHeader(new String[0]).build();
        try (CSVParser parser = CSVParser.parse((String)"A,A,B,B\n1,2,5,6\n", (CSVFormat)format);){
            CSVRecord record = parser.nextRecord();
            Assertions.assertAll((String)"Test that it gets the last instance of a column when there are duplicate headings", (Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"2", (Object)record.get("A")), () -> Assertions.assertEquals((Object)"6", (Object)record.get("B"))});
        }
    }

    @Test
    public void testDuplicateHeaderToMap() throws IOException {
        String csv = "A,A,B,B\n1,2,5,6\n";
        CSVFormat format = CSVFormat.DEFAULT.builder().setHeader(new String[0]).build();
        try (CSVParser parser = CSVParser.parse((String)"A,A,B,B\n1,2,5,6\n", (CSVFormat)format);){
            CSVRecord record = parser.nextRecord();
            Map map = record.toMap();
            Assertions.assertAll((String)"Test that it gets the last instance of a column when there are duplicate headings", (Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"2", map.get("A")), () -> Assertions.assertEquals((Object)"6", map.get("B"))});
        }
    }

    @Test
    public void testGetInt() {
        Assertions.assertEquals((Object)this.values[0], (Object)this.record.get(0));
        Assertions.assertEquals((Object)this.values[1], (Object)this.record.get(1));
        Assertions.assertEquals((Object)this.values[2], (Object)this.record.get(2));
    }

    @Test
    public void testGetNullEnum() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recordWithHeader.get((Enum)null));
    }

    @Test
    public void testGetString() {
        Assertions.assertEquals((Object)this.values[0], (Object)this.recordWithHeader.get(EnumHeader.FIRST.name()));
        Assertions.assertEquals((Object)this.values[1], (Object)this.recordWithHeader.get(EnumHeader.SECOND.name()));
        Assertions.assertEquals((Object)this.values[2], (Object)this.recordWithHeader.get(EnumHeader.THIRD.name()));
    }

    @Test
    public void testGetStringInconsistentRecord() {
        this.headerMap.put("fourth", 4);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recordWithHeader.get("fourth"));
    }

    @Test
    public void testGetStringNoHeader() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.record.get("first"));
    }

    @Test
    public void testGetUnmappedEnum() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recordWithHeader.get((Enum)EnumFixture.UNKNOWN_COLUMN));
    }

    @Test
    public void testGetUnmappedName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Assertions.assertNull((Object)this.recordWithHeader.get("fourth")));
    }

    @Test
    public void testGetUnmappedNegativeInt() {
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.recordWithHeader.get(Integer.MIN_VALUE));
    }

    @Test
    public void testGetUnmappedPositiveInt() {
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> this.recordWithHeader.get(Integer.MAX_VALUE));
    }

    @Test
    public void testGetWithEnum() {
        Assertions.assertEquals((Object)this.recordWithHeader.get("FIRST"), (Object)this.recordWithHeader.get((Enum)EnumHeader.FIRST));
        Assertions.assertEquals((Object)this.recordWithHeader.get("SECOND"), (Object)this.recordWithHeader.get((Enum)EnumHeader.SECOND));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.recordWithHeader.get((Enum)EnumFixture.UNKNOWN_COLUMN));
    }

    @Test
    public void testIsConsistent() {
        Assertions.assertTrue((boolean)this.record.isConsistent());
        Assertions.assertTrue((boolean)this.recordWithHeader.isConsistent());
        Map map = this.recordWithHeader.getParser().getHeaderMap();
        map.put("fourth", 4);
        Assertions.assertTrue((boolean)this.recordWithHeader.isConsistent());
    }

    @Test
    public void testIsInconsistent() throws IOException {
        String[] headers = new String[]{"first", "second", "third"};
        String rowData = StringUtils.join((Object[])this.values, (char)',');
        try (CSVParser parser = CSVFormat.DEFAULT.withHeader(headers).parse((Reader)new StringReader(rowData));){
            Map map = parser.getHeaderMapRaw();
            CSVRecord record1 = (CSVRecord)parser.iterator().next();
            map.put("fourth", 4);
            Assertions.assertFalse((boolean)record1.isConsistent());
        }
    }

    @Test
    public void testIsMapped() {
        Assertions.assertFalse((boolean)this.record.isMapped("first"));
        Assertions.assertTrue((boolean)this.recordWithHeader.isMapped(EnumHeader.FIRST.name()));
        Assertions.assertFalse((boolean)this.recordWithHeader.isMapped("fourth"));
    }

    @Test
    public void testIsSetInt() {
        Assertions.assertFalse((boolean)this.record.isSet(-1));
        Assertions.assertTrue((boolean)this.record.isSet(0));
        Assertions.assertTrue((boolean)this.record.isSet(2));
        Assertions.assertFalse((boolean)this.record.isSet(3));
        Assertions.assertTrue((boolean)this.recordWithHeader.isSet(1));
        Assertions.assertFalse((boolean)this.recordWithHeader.isSet(1000));
    }

    @Test
    public void testIsSetString() {
        Assertions.assertFalse((boolean)this.record.isSet("first"));
        Assertions.assertTrue((boolean)this.recordWithHeader.isSet(EnumHeader.FIRST.name()));
        Assertions.assertFalse((boolean)this.recordWithHeader.isSet("DOES NOT EXIST"));
    }

    @Test
    public void testIterator() {
        int i = 0;
        for (String value : this.record) {
            Assertions.assertEquals((Object)this.values[i], (Object)value);
            ++i;
        }
    }

    @Test
    public void testPutInMap() {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        this.recordWithHeader.putIn(map);
        this.validateMap(map, false);
        TreeMap map2 = (TreeMap)this.recordWithHeader.putIn(new TreeMap());
        this.validateMap(map2, false);
    }

    @Test
    public void testRemoveAndAddColumns() throws IOException {
        try (CSVPrinter printer = new CSVPrinter((Appendable)new StringBuilder(), CSVFormat.DEFAULT);){
            Map map = this.recordWithHeader.toMap();
            map.remove("OldColumn");
            map.put("ZColumn", "NewValue");
            ArrayList list = new ArrayList(map.values());
            list.sort(null);
            printer.printRecord(list);
            Assertions.assertEquals((Object)("A,B,C,NewValue" + CSVFormat.DEFAULT.getRecordSeparator()), (Object)printer.getOut().toString());
        }
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        CSVRecord shortRec;
        try (CSVParser parser = CSVParser.parse((String)"A,B\n#my comment\nOne,Two", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[0]).withCommentMarker('#'));){
            shortRec = (CSVRecord)parser.iterator().next();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(out);){
            oos.writeObject(shortRec);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(in);){
            Object object = ois.readObject();
            Assertions.assertInstanceOf(CSVRecord.class, (Object)object);
            CSVRecord rec = (CSVRecord)object;
            Assertions.assertEquals((long)1L, (long)rec.getRecordNumber());
            Assertions.assertEquals((Object)"One", (Object)rec.get(0));
            Assertions.assertEquals((Object)"Two", (Object)rec.get(1));
            Assertions.assertEquals((int)2, (int)rec.size());
            Assertions.assertEquals((long)shortRec.getCharacterPosition(), (long)rec.getCharacterPosition());
            Assertions.assertEquals((Object)"my comment", (Object)rec.getComment());
            Assertions.assertNull((Object)rec.getParser());
            Assertions.assertTrue((boolean)rec.isConsistent());
            Assertions.assertFalse((boolean)rec.isMapped("A"));
            Assertions.assertFalse((boolean)rec.isSet("A"));
            Assertions.assertEquals((int)0, (int)rec.toMap().size());
            Assertions.assertThrows(IllegalStateException.class, () -> rec.get("A"));
        }
    }

    @Test
    public void testStream() {
        AtomicInteger i = new AtomicInteger();
        this.record.stream().forEach(value -> {
            Assertions.assertEquals((Object)this.values[i.get()], (Object)value);
            i.incrementAndGet();
        });
    }

    @Test
    public void testToListAdd() {
        Object[] expected = (String[])this.values.clone();
        List list = this.record.toList();
        list.add("Last");
        Assertions.assertEquals((Object)"Last", list.get(list.size() - 1));
        Assertions.assertEquals((int)list.size(), (int)(this.values.length + 1));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.values);
    }

    @Test
    public void testToListFor() {
        int i = 0;
        for (String value : this.record.toList()) {
            Assertions.assertEquals((Object)this.values[i], (Object)value);
            ++i;
        }
    }

    @Test
    public void testToListForEach() {
        AtomicInteger i = new AtomicInteger();
        this.record.toList().forEach(e -> Assertions.assertEquals((Object)this.values[i.getAndIncrement()], (Object)e));
    }

    @Test
    public void testToListSet() {
        Object[] expected = (String[])this.values.clone();
        List list = this.record.toList();
        list.set(list.size() - 1, "Last");
        Assertions.assertEquals((Object)"Last", list.get(list.size() - 1));
        Assertions.assertEquals((int)list.size(), (int)this.values.length);
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.values);
    }

    @Test
    public void testToMap() {
        Map map = this.recordWithHeader.toMap();
        this.validateMap(map, true);
    }

    @Test
    public void testToMapWithNoHeader() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"a,b", (CSVFormat)CSVFormat.newFormat((char)','));){
            CSVRecord shortRec = (CSVRecord)parser.iterator().next();
            Map map = shortRec.toMap();
            Assertions.assertNotNull((Object)map, (String)"Map is not null.");
            Assertions.assertTrue((boolean)map.isEmpty(), (String)"Map is empty.");
        }
    }

    @Test
    public void testToMapWithShortRecord() throws Exception {
        try (CSVParser parser = CSVParser.parse((String)"a,b", (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[]{"A", "B", "C"}));){
            CSVRecord shortRec = (CSVRecord)parser.iterator().next();
            shortRec.toMap();
        }
    }

    @Test
    public void testToString() {
        Assertions.assertNotNull((Object)this.recordWithHeader.toString());
        Assertions.assertTrue((boolean)this.recordWithHeader.toString().contains("comment="));
        Assertions.assertTrue((boolean)this.recordWithHeader.toString().contains("recordNumber="));
        Assertions.assertTrue((boolean)this.recordWithHeader.toString().contains("values="));
    }

    private void validateMap(Map<String, String> map, boolean allowsNulls) {
        Assertions.assertTrue((boolean)map.containsKey(EnumHeader.FIRST.name()));
        Assertions.assertTrue((boolean)map.containsKey(EnumHeader.SECOND.name()));
        Assertions.assertTrue((boolean)map.containsKey(EnumHeader.THIRD.name()));
        Assertions.assertFalse((boolean)map.containsKey("fourth"));
        if (allowsNulls) {
            Assertions.assertFalse((boolean)map.containsKey(null));
        }
        Assertions.assertEquals((Object)"A", (Object)map.get(EnumHeader.FIRST.name()));
        Assertions.assertEquals((Object)"B", (Object)map.get(EnumHeader.SECOND.name()));
        Assertions.assertEquals((Object)"C", (Object)map.get(EnumHeader.THIRD.name()));
        Assertions.assertNull((Object)map.get("fourth"));
    }

    public static enum EnumHeader {
        FIRST("first"),
        SECOND("second"),
        THIRD("third");

        private final String number;

        private EnumHeader(String number) {
            this.number = number;
        }

        public String toString() {
            return this.number;
        }
    }

    private static enum EnumFixture {
        UNKNOWN_COLUMN;

    }
}

