/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.DuplicateHeaderMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv264Test {
    private static final String CSV_STRING = "\"\",\"B\",\"\"\n\"1\",\"2\",\"3\"\n\"4\",\"5\",\"6\"";
    private static final String CSV_STRING_GAP = "\"A\",\"B\",\"\",\"\",\"E\"\n\"1\",\"2\",\"\",\"\",\"5\"\n\"6\",\"7\",\"\",\"\",\"10\"";

    @Test
    public void testJiraCsv264() {
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setHeader(new String[0]).setDuplicateHeaderMode(DuplicateHeaderMode.DISALLOW).setAllowMissingColumnNames(true).build();
        try (StringReader reader = new StringReader(CSV_STRING);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> csvFormat.parse((Reader)reader));
        }
    }

    @Test
    public void testJiraCsv264WithGapAllowEmpty() throws IOException {
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setHeader(new String[0]).setDuplicateHeaderMode(DuplicateHeaderMode.ALLOW_EMPTY).setAllowMissingColumnNames(true).build();
        try (StringReader reader = new StringReader(CSV_STRING_GAP);){
            CSVParser parser = csvFormat.parse((Reader)reader);
            if (parser != null) {
                parser.close();
            }
        }
    }

    @Test
    public void testJiraCsv264WithGapDisallow() {
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setHeader(new String[0]).setDuplicateHeaderMode(DuplicateHeaderMode.DISALLOW).setAllowMissingColumnNames(true).build();
        try (StringReader reader = new StringReader(CSV_STRING_GAP);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> csvFormat.parse((Reader)reader));
        }
    }
}

