/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.IOException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JiraCsv154Test {
    @Test
    public void testJiraCsv154_withCommentMarker() throws IOException {
        String comment = "This is a header comment";
        CSVFormat format = CSVFormat.EXCEL.builder().setHeader(new String[]{"H1", "H2"}).setCommentMarker('#').setHeaderComments(new String[]{"This is a header comment"}).build();
        StringBuilder out = new StringBuilder();
        try (CSVPrinter printer = format.print((Appendable)out);){
            printer.print((Object)"A");
            printer.print((Object)"B");
        }
        String s = out.toString();
        Assertions.assertTrue((boolean)s.contains("This is a header comment"), (String)s);
    }

    @Test
    public void testJiraCsv154_withHeaderComments() throws IOException {
        String comment = "This is a header comment";
        CSVFormat format = CSVFormat.EXCEL.builder().setHeader(new String[]{"H1", "H2"}).setHeaderComments(new String[]{"This is a header comment"}).setCommentMarker('#').build();
        StringBuilder out = new StringBuilder();
        try (CSVPrinter printer = format.print((Appendable)out);){
            printer.print((Object)"A");
            printer.print((Object)"B");
        }
        String s = out.toString();
        Assertions.assertTrue((boolean)s.contains("This is a header comment"), (String)s);
    }
}

