/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.junit.Assert;
import org.junit.Test;

public class FercGovTest {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContractFile() throws IOException {
        URL contractData = ClassLoader.getSystemClassLoader().getResource("ferc.gov/contract.txt");
        CSVParser parser = CSVParser.parse((URL)contractData, (Charset)US_ASCII, (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[0]));
        try {
            List records = parser.getRecords();
            CSVRecord record = (CSVRecord)records.get(0);
            Assert.assertEquals((long)22L, (long)records.size());
            Assert.assertEquals((Object)"C71", (Object)record.get((Enum)ContractColumnNames.contract_id));
            Assert.assertEquals((Object)"The Electric Company", (Object)record.get((Enum)ContractColumnNames.seller_company_name));
            Assert.assertEquals((Object)"ES", (Object)record.get((Enum)ContractColumnNames.time_zone));
            record = (CSVRecord)records.get(records.size() - 1);
            Assert.assertEquals((Object)"C78", (Object)record.get((Enum)ContractColumnNames.contract_id));
            Assert.assertEquals((Object)"The Electric Company", (Object)record.get((Enum)ContractColumnNames.seller_company_name));
            Assert.assertEquals((Object)"EP", (Object)record.get((Enum)ContractColumnNames.time_zone));
        }
        finally {
            parser.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionFile() throws IOException {
        URL transactionData = ClassLoader.getSystemClassLoader().getResource("ferc.gov/transaction.txt");
        CSVParser parser = CSVParser.parse((URL)transactionData, (Charset)US_ASCII, (CSVFormat)CSVFormat.DEFAULT.withHeader(new String[0]));
        try {
            List records = parser.getRecords();
            Assert.assertEquals((long)24L, (long)records.size());
            CSVRecord record = (CSVRecord)records.get(0);
            Assert.assertEquals((Object)"T1", (Object)record.get("transaction_unique_identifier"));
            Assert.assertEquals((Object)"The Electric Company", (Object)record.get("seller_company_name"));
            Assert.assertEquals((Object)"880386", (Object)record.get("transaction_charge"));
            record = (CSVRecord)records.get(records.size() - 1);
            Assert.assertEquals((Object)"T15", (Object)record.get("transaction_unique_identifier"));
            Assert.assertEquals((Object)"The Electric Company", (Object)record.get("seller_company_name"));
            Assert.assertEquals((Object)"1800", (Object)record.get("transaction_charge"));
        }
        finally {
            parser.close();
        }
    }

    private static enum ContractColumnNames {
        contract_id,
        seller_company_name,
        customer_company_name,
        customer_duns_number,
        contract_affiliate,
        FERC_tariff_reference,
        contract_service_agreement_id,
        contract_execution_date,
        contract_commencement_date,
        contract_termination_date,
        actual_termination_date,
        extension_provision_description,
        class_name,
        term_name,
        increment_name,
        increment_peaking_name,
        product_type_name,
        product_name,
        quantity,
        units_for_contract,
        rate,
        rate_minimum,
        rate_maximum,
        rate_description,
        units_for_rate,
        point_of_receipt_control_area,
        point_of_receipt_specific_location,
        point_of_delivery_control_area,
        point_of_delivery_specific_location,
        begin_date,
        end_date,
        time_zone;

    }
}

