/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.csv.ExtendedBufferedReader;
import org.junit.Assert;
import org.junit.Test;

public class ExtendedBufferedReaderTest {
    @Test
    public void testEmptyInput() throws Exception {
        ExtendedBufferedReader br = this.getBufferedReader("");
        Assert.assertEquals((long)-1L, (long)br.read());
        Assert.assertEquals((long)-1L, (long)br.lookAhead());
        Assert.assertEquals((long)-1L, (long)br.getLastChar());
        Assert.assertNull((Object)br.readLine());
        Assert.assertEquals((long)0L, (long)br.read(new char[10], 0, 0));
        br.close();
    }

    @Test
    public void testReadLookahead1() throws Exception {
        ExtendedBufferedReader br = this.getBufferedReader("1\n2\r3\n");
        Assert.assertEquals((long)0L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)49L, (long)br.lookAhead());
        Assert.assertEquals((long)-2L, (long)br.getLastChar());
        Assert.assertEquals((long)0L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)49L, (long)br.read());
        Assert.assertEquals((long)49L, (long)br.getLastChar());
        Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)10L, (long)br.lookAhead());
        Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)49L, (long)br.getLastChar());
        Assert.assertEquals((long)10L, (long)br.read());
        Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)10L, (long)br.getLastChar());
        Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)50L, (long)br.lookAhead());
        Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)10L, (long)br.getLastChar());
        Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)50L, (long)br.read());
        Assert.assertEquals((long)2L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)50L, (long)br.getLastChar());
        Assert.assertEquals((long)13L, (long)br.lookAhead());
        Assert.assertEquals((long)2L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)50L, (long)br.getLastChar());
        Assert.assertEquals((long)13L, (long)br.read());
        Assert.assertEquals((long)13L, (long)br.getLastChar());
        Assert.assertEquals((long)2L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)51L, (long)br.lookAhead());
        Assert.assertEquals((long)13L, (long)br.getLastChar());
        Assert.assertEquals((long)51L, (long)br.read());
        Assert.assertEquals((long)51L, (long)br.getLastChar());
        Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)10L, (long)br.lookAhead());
        Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)51L, (long)br.getLastChar());
        Assert.assertEquals((long)10L, (long)br.read());
        Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)10L, (long)br.getLastChar());
        Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)-1L, (long)br.lookAhead());
        Assert.assertEquals((long)10L, (long)br.getLastChar());
        Assert.assertEquals((long)-1L, (long)br.read());
        Assert.assertEquals((long)-1L, (long)br.getLastChar());
        Assert.assertEquals((long)-1L, (long)br.read());
        Assert.assertEquals((long)-1L, (long)br.lookAhead());
        Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        br.close();
    }

    @Test
    public void testReadLookahead2() throws Exception {
        char[] ref = new char[5];
        char[] res = new char[5];
        ExtendedBufferedReader br = this.getBufferedReader("abcdefg");
        ref[0] = 97;
        ref[1] = 98;
        ref[2] = 99;
        Assert.assertEquals((long)3L, (long)br.read(res, 0, 3));
        Assert.assertArrayEquals((char[])ref, (char[])res);
        Assert.assertEquals((long)99L, (long)br.getLastChar());
        Assert.assertEquals((long)100L, (long)br.lookAhead());
        ref[4] = 100;
        Assert.assertEquals((long)1L, (long)br.read(res, 4, 1));
        Assert.assertArrayEquals((char[])ref, (char[])res);
        Assert.assertEquals((long)100L, (long)br.getLastChar());
        br.close();
    }

    @Test
    public void testReadLine() throws Exception {
        ExtendedBufferedReader br = this.getBufferedReader("");
        Assert.assertNull((Object)br.readLine());
        br.close();
        br = this.getBufferedReader("\n");
        Assert.assertEquals((Object)"", (Object)br.readLine());
        Assert.assertNull((Object)br.readLine());
        br.close();
        br = this.getBufferedReader("foo\n\nhello");
        Assert.assertEquals((long)0L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((Object)"foo", (Object)br.readLine());
        Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((Object)"", (Object)br.readLine());
        Assert.assertEquals((long)2L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((Object)"hello", (Object)br.readLine());
        Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        Assert.assertNull((Object)br.readLine());
        Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        br.close();
        br = this.getBufferedReader("foo\n\nhello");
        Assert.assertEquals((long)102L, (long)br.read());
        Assert.assertEquals((long)111L, (long)br.lookAhead());
        Assert.assertEquals((Object)"oo", (Object)br.readLine());
        Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)10L, (long)br.lookAhead());
        Assert.assertEquals((Object)"", (Object)br.readLine());
        Assert.assertEquals((long)2L, (long)br.getCurrentLineNumber());
        Assert.assertEquals((long)104L, (long)br.lookAhead());
        Assert.assertEquals((Object)"hello", (Object)br.readLine());
        Assert.assertNull((Object)br.readLine());
        Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        br.close();
        br = this.getBufferedReader("foo\rbaar\r\nfoo");
        Assert.assertEquals((Object)"foo", (Object)br.readLine());
        Assert.assertEquals((long)98L, (long)br.lookAhead());
        Assert.assertEquals((Object)"baar", (Object)br.readLine());
        Assert.assertEquals((long)102L, (long)br.lookAhead());
        Assert.assertEquals((Object)"foo", (Object)br.readLine());
        Assert.assertNull((Object)br.readLine());
        br.close();
    }

    @Test
    public void testReadChar() throws Exception {
        String LF = "\n";
        String CR = "\r";
        String CRLF = "\r\n";
        String LFCR = "\n\r";
        String test = "a\nb\rc\n\nd\r\re\n\rf \r\n";
        int EOLeolct = 9;
        ExtendedBufferedReader br = this.getBufferedReader("a\nb\rc\n\nd\r\re\n\rf \r\n");
        Assert.assertEquals((long)0L, (long)br.getCurrentLineNumber());
        while (br.readLine() != null) {
        }
        Assert.assertEquals((long)9L, (long)br.getCurrentLineNumber());
        br.close();
        br = this.getBufferedReader("a\nb\rc\n\nd\r\re\n\rf \r\n");
        Assert.assertEquals((long)0L, (long)br.getCurrentLineNumber());
        while (br.read() != -1) {
        }
        Assert.assertEquals((long)9L, (long)br.getCurrentLineNumber());
        br.close();
        br = this.getBufferedReader("a\nb\rc\n\nd\r\re\n\rf \r\n");
        Assert.assertEquals((long)0L, (long)br.getCurrentLineNumber());
        char[] buff = new char[10];
        while (br.read(buff, 0, 3) != -1) {
        }
        Assert.assertEquals((long)9L, (long)br.getCurrentLineNumber());
        br.close();
    }

    private ExtendedBufferedReader getBufferedReader(String s) {
        return new ExtendedBufferedReader((Reader)new StringReader(s));
    }
}

