/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.csv.Utils;
import org.junit.Assert;
import org.junit.Test;

public class CSVPrinterTest {
    private final String recordSeparator = CSVFormat.DEFAULT.getRecordSeparator();

    private static String printable(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch <= ' ' || ch >= '\u0080') {
                sb.append("(").append((int)ch).append(")");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private void doOneRandom(CSVFormat format) throws Exception {
        Random r = new Random();
        int nLines = r.nextInt(4) + 1;
        int nCol = r.nextInt(3) + 1;
        String[][] lines = new String[nLines][];
        for (int i = 0; i < nLines; ++i) {
            String[] line = new String[nCol];
            lines[i] = line;
            for (int j = 0; j < nCol; ++j) {
                line[j] = this.randStr();
            }
        }
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, format);
        for (int i = 0; i < nLines; ++i) {
            printer.printRecord((Object[])lines[i]);
        }
        printer.flush();
        printer.close();
        String result = sw.toString();
        CSVParser parser = CSVParser.parse((String)result, (CSVFormat)format);
        List parseResult = parser.getRecords();
        Utils.compare("Printer output :" + CSVPrinterTest.printable(result), lines, parseResult);
        parser.close();
    }

    private void doRandom(CSVFormat format, int iter) throws Exception {
        for (int i = 0; i < iter; ++i) {
            this.doOneRandom(format);
        }
    }

    private String randStr() {
        Random r = new Random();
        int sz = r.nextInt(20);
        char[] buf = new char[sz];
        for (int i = 0; i < sz; ++i) {
            int ch;
            int what = r.nextInt(20);
            switch (what) {
                case 0: {
                    ch = 13;
                    break;
                }
                case 1: {
                    ch = 10;
                    break;
                }
                case 2: {
                    ch = 9;
                    break;
                }
                case 3: {
                    ch = 12;
                    break;
                }
                case 4: {
                    ch = 32;
                    break;
                }
                case 5: {
                    ch = 44;
                    break;
                }
                case 6: {
                    ch = 34;
                    break;
                }
                case 7: {
                    ch = 39;
                    break;
                }
                case 8: {
                    ch = 92;
                    break;
                }
                default: {
                    ch = (char)r.nextInt(300);
                }
            }
            buf[i] = ch;
        }
        return new String(buf);
    }

    @Test
    public void testDisabledComment() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);
        printer.printComment("This is a comment");
        Assert.assertEquals((Object)"", (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testExcelPrintAllArrayOfArrays() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.EXCEL);
        printer.printRecords((Object[])new String[][]{{"r1c1", "r1c2"}, {"r2c1", "r2c2"}});
        Assert.assertEquals((Object)("r1c1,r1c2" + this.recordSeparator + "r2c1,r2c2" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testExcelPrintAllArrayOfLists() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.EXCEL);
        printer.printRecords((Object[])new List[]{Arrays.asList("r1c1", "r1c2"), Arrays.asList("r2c1", "r2c2")});
        Assert.assertEquals((Object)("r1c1,r1c2" + this.recordSeparator + "r2c1,r2c2" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testExcelPrintAllIterableOfArrays() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.EXCEL);
        printer.printRecords(Arrays.asList({"r1c1", "r1c2"}, {"r2c1", "r2c2"}));
        Assert.assertEquals((Object)("r1c1,r1c2" + this.recordSeparator + "r2c1,r2c2" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testExcelPrintAllIterableOfLists() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.EXCEL);
        printer.printRecords(Arrays.asList(Arrays.asList("r1c1", "r1c2"), Arrays.asList("r2c1", "r2c2")));
        Assert.assertEquals((Object)("r1c1,r1c2" + this.recordSeparator + "r2c1,r2c2" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testExcelPrinter1() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.EXCEL);
        printer.printRecord(new Object[]{"a", "b"});
        Assert.assertEquals((Object)("a,b" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testExcelPrinter2() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.EXCEL);
        printer.printRecord(new Object[]{"a,b", "b"});
        Assert.assertEquals((Object)("\"a,b\",b" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJdbcPrinter() throws IOException, ClassNotFoundException, SQLException {
        StringWriter sw = new StringWriter();
        Class.forName("org.h2.Driver");
        Connection connection = DriverManager.getConnection("jdbc:h2:mem:my_test;", "sa", "");
        try {
            Statement stmt = connection.createStatement();
            stmt.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
            stmt.execute("insert into TEST values(1, 'r1')");
            stmt.execute("insert into TEST values(2, 'r2')");
            CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);
            printer.printRecords(stmt.executeQuery("select ID, NAME from TEST"));
            Assert.assertEquals((Object)("1,r1" + this.recordSeparator + "2,r2" + this.recordSeparator), (Object)sw.toString());
            printer.close();
        }
        finally {
            connection.close();
        }
    }

    @Test
    public void testMultiLineComment() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withCommentMarker('#'));
        printer.printComment("This is a comment\non multiple lines");
        Assert.assertEquals((Object)("# This is a comment" + this.recordSeparator + "# on multiple lines" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testPrinter1() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);
        printer.printRecord(new Object[]{"a", "b"});
        Assert.assertEquals((Object)("a,b" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testPrinter2() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);
        printer.printRecord(new Object[]{"a,b", "b"});
        Assert.assertEquals((Object)("\"a,b\",b" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testPrinter3() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);
        printer.printRecord(new Object[]{"a, b", "b "});
        Assert.assertEquals((Object)("\"a, b\",\"b \"" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testPrinter4() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);
        printer.printRecord(new Object[]{"a", "b\"c"});
        Assert.assertEquals((Object)("a,\"b\"\"c\"" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testPrinter5() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);
        printer.printRecord(new Object[]{"a", "b\nc"});
        Assert.assertEquals((Object)("a,\"b\nc\"" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testPrinter6() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);
        printer.printRecord(new Object[]{"a", "b\r\nc"});
        Assert.assertEquals((Object)("a,\"b\r\nc\"" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testPrinter7() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);
        printer.printRecord(new Object[]{"a", "b\\c"});
        Assert.assertEquals((Object)("a,b\\c" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testPrint() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = CSVFormat.DEFAULT.print((Appendable)sw);
        printer.printRecord(new Object[]{"a", "b\\c"});
        Assert.assertEquals((Object)("a,b\\c" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testPrintNullValues() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);
        printer.printRecord(new Object[]{"a", null, "b"});
        Assert.assertEquals((Object)("a,,b" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testPrintCustomNullValues() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withNullString("NULL"));
        printer.printRecord(new Object[]{"a", null, "b"});
        Assert.assertEquals((Object)("a,NULL,b" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testParseCustomNullValues() throws IOException {
        StringWriter sw = new StringWriter();
        CSVFormat format = CSVFormat.DEFAULT.withNullString("NULL");
        CSVPrinter printer = new CSVPrinter((Appendable)sw, format);
        printer.printRecord(new Object[]{"a", null, "b"});
        printer.close();
        String csvString = sw.toString();
        Assert.assertEquals((Object)("a,NULL,b" + this.recordSeparator), (Object)csvString);
        CSVParser iterable = format.parse((Reader)new StringReader(csvString));
        Iterator iterator = iterable.iterator();
        CSVRecord record = (CSVRecord)iterator.next();
        Assert.assertEquals((Object)"a", (Object)record.get(0));
        Assert.assertEquals(null, (Object)record.get(1));
        Assert.assertEquals((Object)"b", (Object)record.get(2));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterable.close();
    }

    @Test
    public void testQuoteAll() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuoteMode(QuoteMode.ALL));
        printer.printRecord(new Object[]{"a", "b\nc", "d"});
        Assert.assertEquals((Object)("\"a\",\"b\nc\",\"d\"" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testQuoteNonNumeric() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuoteMode(QuoteMode.NON_NUMERIC));
        printer.printRecord(new Object[]{"a", "b\nc", 1});
        Assert.assertEquals((Object)("\"a\",\"b\nc\",1" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testRandom() throws Exception {
        int iter = 10000;
        this.doRandom(CSVFormat.DEFAULT, 10000);
        this.doRandom(CSVFormat.EXCEL, 10000);
        this.doRandom(CSVFormat.MYSQL, 10000);
    }

    @Test
    public void testPlainQuoted() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));
        printer.print((Object)"abc");
        Assert.assertEquals((Object)"abc", (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testSingleLineComment() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withCommentMarker('#'));
        printer.printComment("This is a comment");
        Assert.assertEquals((Object)("# This is a comment" + this.recordSeparator), (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testSingleQuoteQuoted() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));
        printer.print((Object)"a'b'c");
        printer.print((Object)"xyz");
        Assert.assertEquals((Object)"'a''b''c',xyz", (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testDelimeterQuoted() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));
        printer.print((Object)"a,b,c");
        printer.print((Object)"xyz");
        Assert.assertEquals((Object)"'a,b,c',xyz", (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testDelimeterQuoteNONE() throws IOException {
        StringWriter sw = new StringWriter();
        CSVFormat format = CSVFormat.DEFAULT.withEscape('!').withQuoteMode(QuoteMode.NONE);
        CSVPrinter printer = new CSVPrinter((Appendable)sw, format);
        printer.print((Object)"a,b,c");
        printer.print((Object)"xyz");
        Assert.assertEquals((Object)"a!,b!,c,xyz", (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testEOLQuoted() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote('\''));
        printer.print((Object)"a\rb\nc");
        printer.print((Object)"x\by\fz");
        Assert.assertEquals((Object)"'a\rb\nc',x\by\fz", (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testPlainEscaped() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null).withEscape('!'));
        printer.print((Object)"abc");
        printer.print((Object)"xyz");
        Assert.assertEquals((Object)"abc,xyz", (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testDelimiterEscaped() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withEscape('!').withQuote(null));
        printer.print((Object)"a,b,c");
        printer.print((Object)"xyz");
        Assert.assertEquals((Object)"a!,b!,c,xyz", (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testEOLEscaped() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null).withEscape('!'));
        printer.print((Object)"a\rb\nc");
        printer.print((Object)"x\fy\bz");
        Assert.assertEquals((Object)"a!rb!nc,x\fy\bz", (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testPlainPlain() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null));
        printer.print((Object)"abc");
        printer.print((Object)"xyz");
        Assert.assertEquals((Object)"abc,xyz", (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testDelimiterPlain() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null));
        printer.print((Object)"a,b,c");
        printer.print((Object)"xyz");
        Assert.assertEquals((Object)"a,b,c,xyz", (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testHeader() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null).withHeader(new String[]{"C1", "C2", "C3"}));
        printer.printRecord(new Object[]{"a", "b", "c"});
        printer.printRecord(new Object[]{"x", "y", "z"});
        Assert.assertEquals((Object)"C1,C2,C3\r\na,b,c\r\nx,y,z\r\n", (Object)sw.toString());
        printer.close();
    }

    @Test
    public void testEOLPlain() throws IOException {
        StringWriter sw = new StringWriter();
        CSVPrinter printer = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT.withQuote(null));
        printer.print((Object)"a\rb\nc");
        printer.print((Object)"x\fy\bz");
        Assert.assertEquals((Object)"a\rb\nc,x\fy\bz", (Object)sw.toString());
        printer.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidFormat() throws Exception {
        CSVFormat invalidFormat = CSVFormat.DEFAULT.withDelimiter('\r');
        new CSVPrinter((Appendable)new StringWriter(), invalidFormat).close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNewCSVPrinterNullAppendableFormat() throws Exception {
        new CSVPrinter(null, CSVFormat.DEFAULT).close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNewCsvPrinterAppendableNullFormat() throws Exception {
        new CSVPrinter((Appendable)new StringWriter(), null).close();
    }
}

