/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.junit.Assert;
import org.junit.Test;

public class CSVFormatTest {
    private static void assertNotEquals(Object right, Object left) {
        Assert.assertFalse((boolean)right.equals(left));
        Assert.assertFalse((boolean)left.equals(right));
    }

    private static CSVFormat copy(CSVFormat format) {
        return format.withDelimiter(format.getDelimiter());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDelimiterSameAsCommentStartThrowsException() {
        CSVFormat.DEFAULT.withDelimiter('!').withCommentMarker('!');
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDelimiterSameAsEscapeThrowsException() {
        CSVFormat.DEFAULT.withDelimiter('!').withEscape('!');
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDuplicateHeaderElements() {
        CSVFormat.DEFAULT.withHeader(new String[]{"A", "A"});
    }

    @Test
    public void testEquals() {
        CSVFormat right = CSVFormat.DEFAULT;
        CSVFormat left = CSVFormatTest.copy(right);
        Assert.assertFalse((boolean)right.equals(null));
        Assert.assertFalse((boolean)right.equals((Object)"A String Instance"));
        Assert.assertEquals((Object)right, (Object)right);
        Assert.assertEquals((Object)right, (Object)left);
        Assert.assertEquals((Object)left, (Object)right);
        Assert.assertEquals((long)right.hashCode(), (long)right.hashCode());
        Assert.assertEquals((long)right.hashCode(), (long)left.hashCode());
    }

    @Test
    public void testEqualsCommentStart() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withQuote('\"').withCommentMarker('#').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withCommentMarker('!');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsDelimiter() {
        CSVFormat right = CSVFormat.newFormat((char)'!');
        CSVFormat left = CSVFormat.newFormat((char)'?');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsEscape() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withQuote('\"').withCommentMarker('#').withEscape('+').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withEscape('!');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsHeader() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withRecordSeparator('\r').withCommentMarker('#').withEscape('+').withHeader(new String[]{"One", "Two", "Three"}).withIgnoreEmptyLines(true).withIgnoreSurroundingSpaces(true).withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withHeader(new String[]{"Three", "Two", "One"});
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsIgnoreEmptyLines() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withCommentMarker('#').withEscape('+').withIgnoreEmptyLines(true).withIgnoreSurroundingSpaces(true).withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withIgnoreEmptyLines(false);
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsIgnoreSurroundingSpaces() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withCommentMarker('#').withEscape('+').withIgnoreSurroundingSpaces(true).withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withIgnoreSurroundingSpaces(false);
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsQuoteChar() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withQuote('\"');
        CSVFormat left = right.withQuote('!');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsQuotePolicy() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withQuoteMode(QuoteMode.MINIMAL);
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsRecordSeparator() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withRecordSeparator('\r').withCommentMarker('#').withEscape('+').withIgnoreEmptyLines(true).withIgnoreSurroundingSpaces(true).withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withRecordSeparator('\n');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsNullString() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withRecordSeparator('\r').withCommentMarker('#').withEscape('+').withIgnoreEmptyLines(true).withIgnoreSurroundingSpaces(true).withQuote('\"').withQuoteMode(QuoteMode.ALL).withNullString("null");
        CSVFormat left = right.withNullString("---");
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsSkipHeaderRecord() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withRecordSeparator('\r').withCommentMarker('#').withEscape('+').withIgnoreEmptyLines(true).withIgnoreSurroundingSpaces(true).withQuote('\"').withQuoteMode(QuoteMode.ALL).withNullString("null").withSkipHeaderRecord(true);
        CSVFormat left = right.withSkipHeaderRecord(false);
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEscapeSameAsCommentStartThrowsException() {
        CSVFormat.DEFAULT.withEscape('!').withCommentMarker('!');
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEscapeSameAsCommentStartThrowsExceptionForWrapperType() {
        CSVFormat.DEFAULT.withEscape(new Character('!')).withCommentMarker(new Character('!'));
    }

    @Test
    public void testFormat() {
        CSVFormat format = CSVFormat.DEFAULT;
        Assert.assertEquals((Object)"", (Object)format.format(new Object[0]));
        Assert.assertEquals((Object)"a,b,c", (Object)format.format(new Object[]{"a", "b", "c"}));
        Assert.assertEquals((Object)"\"x,y\",z", (Object)format.format(new Object[]{"x,y", "z"}));
    }

    @Test
    public void testGetHeader() throws Exception {
        String[] header = new String[]{"one", "two", "three"};
        CSVFormat formatWithHeader = CSVFormat.DEFAULT.withHeader(header);
        Object[] headerCopy = formatWithHeader.getHeader();
        headerCopy[0] = "A";
        headerCopy[1] = "B";
        headerCopy[2] = "C";
        Assert.assertFalse((boolean)Arrays.equals(formatWithHeader.getHeader(), headerCopy));
        Assert.assertNotSame((Object)formatWithHeader.getHeader(), (Object)headerCopy);
    }

    @Test
    public void testNullRecordSeparatorCsv106() {
        CSVFormat format = CSVFormat.newFormat((char)';').withSkipHeaderRecord(true).withHeader(new String[]{"H1", "H2"});
        String formatStr = format.format(new Object[]{"A", "B"});
        Assert.assertNotNull((Object)formatStr);
        Assert.assertFalse((boolean)formatStr.endsWith("null"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQuoteCharSameAsCommentStartThrowsException() {
        CSVFormat.DEFAULT.withQuote('!').withCommentMarker('!');
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQuoteCharSameAsCommentStartThrowsExceptionForWrapperType() {
        CSVFormat.DEFAULT.withQuote(new Character('!')).withCommentMarker('!');
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQuoteCharSameAsDelimiterThrowsException() {
        CSVFormat.DEFAULT.withQuote('!').withDelimiter('!');
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQuotePolicyNoneWithoutEscapeThrowsException() {
        CSVFormat.newFormat((char)'!').withQuoteMode(QuoteMode.NONE);
    }

    @Test
    public void testRFC4180() {
        Assert.assertEquals(null, (Object)CSVFormat.RFC4180.getCommentMarker());
        Assert.assertEquals((long)44L, (long)CSVFormat.RFC4180.getDelimiter());
        Assert.assertEquals(null, (Object)CSVFormat.RFC4180.getEscapeCharacter());
        Assert.assertFalse((boolean)CSVFormat.RFC4180.getIgnoreEmptyLines());
        Assert.assertEquals((Object)Character.valueOf('\"'), (Object)CSVFormat.RFC4180.getQuoteCharacter());
        Assert.assertEquals(null, (Object)CSVFormat.RFC4180.getQuoteMode());
        Assert.assertEquals((Object)"\r\n", (Object)CSVFormat.RFC4180.getRecordSeparator());
    }

    @Test
    public void testSerialization() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(CSVFormat.DEFAULT);
        oos.flush();
        oos.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
        CSVFormat format = (CSVFormat)in.readObject();
        Assert.assertNotNull((Object)format);
        Assert.assertEquals((String)"delimiter", (long)CSVFormat.DEFAULT.getDelimiter(), (long)format.getDelimiter());
        Assert.assertEquals((String)"encapsulator", (Object)CSVFormat.DEFAULT.getQuoteCharacter(), (Object)format.getQuoteCharacter());
        Assert.assertEquals((String)"comment start", (Object)CSVFormat.DEFAULT.getCommentMarker(), (Object)format.getCommentMarker());
        Assert.assertEquals((String)"record separator", (Object)CSVFormat.DEFAULT.getRecordSeparator(), (Object)format.getRecordSeparator());
        Assert.assertEquals((String)"escape", (Object)CSVFormat.DEFAULT.getEscapeCharacter(), (Object)format.getEscapeCharacter());
        Assert.assertEquals((String)"trim", (Object)CSVFormat.DEFAULT.getIgnoreSurroundingSpaces(), (Object)format.getIgnoreSurroundingSpaces());
        Assert.assertEquals((String)"empty lines", (Object)CSVFormat.DEFAULT.getIgnoreEmptyLines(), (Object)format.getIgnoreEmptyLines());
    }

    @Test
    public void testWithCommentStart() throws Exception {
        CSVFormat formatWithCommentStart = CSVFormat.DEFAULT.withCommentMarker('#');
        Assert.assertEquals((Object)Character.valueOf('#'), (Object)formatWithCommentStart.getCommentMarker());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithCommentStartCRThrowsException() {
        CSVFormat.DEFAULT.withCommentMarker('\r');
    }

    @Test
    public void testWithDelimiter() throws Exception {
        CSVFormat formatWithDelimiter = CSVFormat.DEFAULT.withDelimiter('!');
        Assert.assertEquals((long)33L, (long)formatWithDelimiter.getDelimiter());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithDelimiterLFThrowsException() {
        CSVFormat.DEFAULT.withDelimiter('\n');
    }

    @Test
    public void testWithEscape() throws Exception {
        CSVFormat formatWithEscape = CSVFormat.DEFAULT.withEscape('&');
        Assert.assertEquals((Object)Character.valueOf('&'), (Object)formatWithEscape.getEscapeCharacter());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithEscapeCRThrowsExceptions() {
        CSVFormat.DEFAULT.withEscape('\r');
    }

    @Test
    public void testWithHeader() throws Exception {
        Object[] header = new String[]{"one", "two", "three"};
        CSVFormat formatWithHeader = CSVFormat.DEFAULT.withHeader((String[])header);
        Assert.assertArrayEquals((Object[])header, (Object[])formatWithHeader.getHeader());
        Assert.assertNotSame((Object)header, (Object)formatWithHeader.getHeader());
        header[0] = "A";
        header[1] = "B";
        header[2] = "C";
        Assert.assertFalse((boolean)Arrays.equals(formatWithHeader.getHeader(), header));
    }

    @Test
    public void testWithIgnoreEmptyLines() throws Exception {
        Assert.assertFalse((boolean)CSVFormat.DEFAULT.withIgnoreEmptyLines(false).getIgnoreEmptyLines());
        Assert.assertTrue((boolean)CSVFormat.DEFAULT.withIgnoreEmptyLines(true).getIgnoreEmptyLines());
    }

    @Test
    public void testWithIgnoreSurround() throws Exception {
        Assert.assertFalse((boolean)CSVFormat.DEFAULT.withIgnoreSurroundingSpaces(false).getIgnoreSurroundingSpaces());
        Assert.assertTrue((boolean)CSVFormat.DEFAULT.withIgnoreSurroundingSpaces(true).getIgnoreSurroundingSpaces());
    }

    @Test
    public void testWithNullString() throws Exception {
        CSVFormat formatWithNullString = CSVFormat.DEFAULT.withNullString("null");
        Assert.assertEquals((Object)"null", (Object)formatWithNullString.getNullString());
    }

    @Test
    public void testWithQuoteChar() throws Exception {
        CSVFormat formatWithQuoteChar = CSVFormat.DEFAULT.withQuote('\"');
        Assert.assertEquals((Object)Character.valueOf('\"'), (Object)formatWithQuoteChar.getQuoteCharacter());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithQuoteLFThrowsException() {
        CSVFormat.DEFAULT.withQuote('\n');
    }

    @Test
    public void testWithQuotePolicy() throws Exception {
        CSVFormat formatWithQuotePolicy = CSVFormat.DEFAULT.withQuoteMode(QuoteMode.ALL);
        Assert.assertEquals((Object)QuoteMode.ALL, (Object)formatWithQuotePolicy.getQuoteMode());
    }

    @Test
    public void testWithRecordSeparatorCR() throws Exception {
        CSVFormat formatWithRecordSeparator = CSVFormat.DEFAULT.withRecordSeparator('\r');
        Assert.assertEquals((Object)String.valueOf('\r'), (Object)formatWithRecordSeparator.getRecordSeparator());
    }

    @Test
    public void testWithRecordSeparatorLF() throws Exception {
        CSVFormat formatWithRecordSeparator = CSVFormat.DEFAULT.withRecordSeparator('\n');
        Assert.assertEquals((Object)String.valueOf('\n'), (Object)formatWithRecordSeparator.getRecordSeparator());
    }

    @Test
    public void testWithRecordSeparatorCRLF() throws Exception {
        CSVFormat formatWithRecordSeparator = CSVFormat.DEFAULT.withRecordSeparator("\r\n");
        Assert.assertEquals((Object)"\r\n", (Object)formatWithRecordSeparator.getRecordSeparator());
    }
}

