/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CSVFileParserTest {
    private static final File BASE = new File("src/test/resources/CSVFileParser");
    private final BufferedReader testData;
    private final String testName;

    public CSVFileParserTest(File file) throws FileNotFoundException {
        this.testName = file.getName();
        this.testData = new BufferedReader(new FileReader(file));
    }

    private String readTestData() throws IOException {
        String line;
        while ((line = this.testData.readLine()) != null && line.startsWith("#")) {
        }
        return line;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        File[] files;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("test") && name.endsWith(".txt");
            }
        };
        for (File f : files = BASE.listFiles(filenameFilter)) {
            list.add(new Object[]{f});
        }
        return list;
    }

    @Test
    public void testCSVFile() throws Exception {
        String line = this.readTestData();
        Assert.assertNotNull((String)"file must contain config line", (Object)line);
        String[] split = line.split(" ");
        Assert.assertTrue((String)(this.testName + " require 1 param"), (split.length >= 1 ? 1 : 0) != 0);
        CSVFormat format = CSVFormat.newFormat((char)',').withQuote('\"');
        boolean checkComments = false;
        for (int i = 1; i < split.length; ++i) {
            String option = split[i];
            String[] option_parts = option.split("=", 2);
            if ("IgnoreEmpty".equalsIgnoreCase(option_parts[0])) {
                format = format.withIgnoreEmptyLines(Boolean.parseBoolean(option_parts[1]));
                continue;
            }
            if ("IgnoreSpaces".equalsIgnoreCase(option_parts[0])) {
                format = format.withIgnoreSurroundingSpaces(Boolean.parseBoolean(option_parts[1]));
                continue;
            }
            if ("CommentStart".equalsIgnoreCase(option_parts[0])) {
                format = format.withCommentMarker(option_parts[1].charAt(0));
                continue;
            }
            if ("CheckComments".equalsIgnoreCase(option_parts[0])) {
                checkComments = true;
                continue;
            }
            Assert.fail((String)(this.testName + " unexpected option: " + option));
        }
        line = this.readTestData();
        Assert.assertEquals((String)(this.testName + " Expected format "), (Object)line, (Object)format.toString());
        CSVParser parser = CSVParser.parse((File)new File(BASE, split[0]), (Charset)Charset.defaultCharset(), (CSVFormat)format);
        for (CSVRecord record : parser) {
            String comment;
            String parsed = record.toString();
            if (checkComments && (comment = record.getComment().replace("\n", "\\n")) != null) {
                parsed = parsed + "#" + comment;
            }
            int count = record.size();
            Assert.assertEquals((String)this.testName, (Object)this.readTestData(), (Object)(count + ":" + parsed));
        }
        parser.close();
    }

    @Test
    public void testCSVUrl() throws Exception {
        String line = this.readTestData();
        Assert.assertNotNull((String)"file must contain config line", (Object)line);
        String[] split = line.split(" ");
        Assert.assertTrue((String)(this.testName + " require 1 param"), (split.length >= 1 ? 1 : 0) != 0);
        CSVFormat format = CSVFormat.newFormat((char)',').withQuote('\"');
        boolean checkComments = false;
        for (int i = 1; i < split.length; ++i) {
            String option = split[i];
            String[] option_parts = option.split("=", 2);
            if ("IgnoreEmpty".equalsIgnoreCase(option_parts[0])) {
                format = format.withIgnoreEmptyLines(Boolean.parseBoolean(option_parts[1]));
                continue;
            }
            if ("IgnoreSpaces".equalsIgnoreCase(option_parts[0])) {
                format = format.withIgnoreSurroundingSpaces(Boolean.parseBoolean(option_parts[1]));
                continue;
            }
            if ("CommentStart".equalsIgnoreCase(option_parts[0])) {
                format = format.withCommentMarker(option_parts[1].charAt(0));
                continue;
            }
            if ("CheckComments".equalsIgnoreCase(option_parts[0])) {
                checkComments = true;
                continue;
            }
            Assert.fail((String)(this.testName + " unexpected option: " + option));
        }
        line = this.readTestData();
        Assert.assertEquals((String)(this.testName + " Expected format "), (Object)line, (Object)format.toString());
        URL resource = ClassLoader.getSystemResource("CSVFileParser/" + split[0]);
        CSVParser parser = CSVParser.parse((URL)resource, (Charset)Charset.forName("UTF-8"), (CSVFormat)format);
        for (CSVRecord record : parser) {
            String comment;
            String parsed = record.toString();
            if (checkComments && (comment = record.getComment().replace("\n", "\\n")) != null) {
                parsed = parsed + "#" + comment;
            }
            int count = record.size();
            Assert.assertEquals((String)this.testName, (Object)this.readTestData(), (Object)(count + ":" + parsed));
        }
        parser.close();
    }
}

