/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.web;

import com.mockobjects.servlet.MockServletConfig;
import com.mockobjects.servlet.MockServletContext;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.TestAbstractConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.web.ServletContextConfiguration;
import org.junit.Test;

public class TestServletContextConfiguration
extends TestAbstractConfiguration {
    @Override
    protected AbstractConfiguration getConfiguration() {
        final Properties parameters = new Properties();
        parameters.setProperty("key1", "value1");
        parameters.setProperty("key2", "value2");
        parameters.setProperty("list", "value1, value2");
        parameters.setProperty("listesc", "value1\\,value2");
        MockServletContext context = new MockServletContext(){

            public String getInitParameter(String key) {
                return parameters.getProperty(key);
            }

            public Enumeration<?> getInitParameterNames() {
                return parameters.keys();
            }
        };
        final MockServletConfig config = new MockServletConfig();
        config.setServletContext((ServletContext)context);
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            public ServletConfig getServletConfig() {
                return config;
            }
        };
        ServletContextConfiguration resultConfig = new ServletContextConfiguration((Servlet)servlet);
        resultConfig.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        return resultConfig;
    }

    @Override
    protected AbstractConfiguration getEmptyConfiguration() {
        MockServletContext context = new MockServletContext(){

            public Enumeration<?> getInitParameterNames() {
                return new Properties().keys();
            }
        };
        return new ServletContextConfiguration((ServletContext)context);
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testAddPropertyDirect() {
        super.testAddPropertyDirect();
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testClearProperty() {
        super.testClearProperty();
    }
}

