/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeSelector;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.QueryResult;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNodeSelector {
    private static final String KEY = "tables.testKey";
    private static ImmutableNode root;
    private static NodeKeyResolver<ImmutableNode> resolver;
    private static NodeHandler<ImmutableNode> handler;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        resolver = TestNodeSelector.createResolver();
        handler = new InMemoryNodeModel().getNodeHandler();
        root = new ImmutableNode.Builder(1).addChild(NodeStructureHelper.ROOT_TABLES_TREE).create();
    }

    private static NodeKeyResolver<ImmutableNode> createResolver() {
        NodeKeyResolver<ImmutableNode> resolver = NodeStructureHelper.createResolverMock();
        NodeStructureHelper.expectResolveKeyForQueries(resolver);
        EasyMock.replay((Object[])new Object[]{resolver});
        return resolver;
    }

    @Test
    public void testSelectSingleKeySuccess() {
        NodeSelector selector = new NodeSelector("tables.table(0).name");
        ImmutableNode target = selector.select(root, resolver, handler);
        Assert.assertEquals((String)"Wrong name", (Object)"name", (Object)target.getNodeName());
        Assert.assertEquals((String)"Wrong value", (Object)NodeStructureHelper.table(0), (Object)target.getValue());
    }

    @Test
    public void testSelectSingleAttributeKey() {
        NodeKeyResolver<ImmutableNode> resolverMock = NodeStructureHelper.createResolverMock();
        EasyMock.expect((Object)resolverMock.resolveKey((Object)root, KEY, handler)).andReturn(Collections.singletonList(QueryResult.createAttributeResult((Object)root, (String)KEY)));
        EasyMock.replay((Object[])new Object[]{resolverMock});
        NodeSelector selector = new NodeSelector(KEY);
        Assert.assertNull((String)"Got a result", (Object)selector.select(root, resolverMock, handler));
    }

    @Test
    public void testSelectIgnoreAttributeResults() {
        NodeKeyResolver<ImmutableNode> resolverMock = NodeStructureHelper.createResolverMock();
        LinkedList<QueryResult> results = new LinkedList<QueryResult>();
        results.add(QueryResult.createAttributeResult((Object)NodeStructureHelper.nodeForKey(root, "tables/table(0)"), (String)"type"));
        ImmutableNode target = NodeStructureHelper.nodeForKey(root, "tables/table(1)");
        results.add(QueryResult.createNodeResult((Object)target));
        results.add(QueryResult.createAttributeResult((Object)NodeStructureHelper.nodeForKey(root, "tables/table(0)/fields/field(1)"), (String)"type"));
        EasyMock.expect((Object)resolverMock.resolveKey((Object)root, KEY, handler)).andReturn(results);
        EasyMock.replay((Object[])new Object[]{resolverMock});
        NodeSelector selector = new NodeSelector(KEY);
        Assert.assertSame((String)"Wrong target", (Object)target, (Object)selector.select(root, resolverMock, handler));
    }

    @Test
    public void testSelectMultipleTargets() {
        NodeSelector selector = new NodeSelector("tables.table.name");
        Assert.assertNull((String)"Got a result", (Object)selector.select(root, resolver, handler));
    }

    @Test
    public void testSelectSubKey() {
        NodeSelector selectorParent = new NodeSelector("tables.table(0)");
        NodeSelector selector = selectorParent.subSelector("fields.field(1).name");
        ImmutableNode target = selector.select(root, resolver, handler);
        Assert.assertEquals((String)"Wrong node selected", (Object)NodeStructureHelper.field(0, 1), (Object)target.getValue());
    }

    @Test
    public void testSelectSubKeyUnknown() {
        NodeSelector selectorParent = new NodeSelector("tables.unknown");
        NodeSelector selector = selectorParent.subSelector("fields.field(1).name");
        Assert.assertNull((String)"Got a result", (Object)selector.select(root, resolver, handler));
    }

    @Test
    public void testSelectSubKeyMultipleResults() {
        NodeSelector selectorParent = new NodeSelector("tables.table");
        NodeSelector selector = selectorParent.subSelector("fields.field(1).name");
        Assert.assertNull((String)"Got a result", (Object)selector.select(root, resolver, handler));
    }

    @Test
    public void testSelectSubKeyComplexEvaluation() {
        NodeSelector first = new NodeSelector("tables.table");
        NodeSelector second = first.subSelector("fields");
        int fldIdx = NodeStructureHelper.fieldsLength(1) - 1;
        NodeSelector selector = second.subSelector("field(" + fldIdx + ").name");
        ImmutableNode target = selector.select(root, resolver, handler);
        Assert.assertEquals((String)"Wrong target node", (Object)NodeStructureHelper.field(1, fldIdx), (Object)target.getValue());
    }

    @Test
    public void testEqualsTrue() {
        NodeSelector selector = new NodeSelector(KEY);
        ConfigurationAssert.checkEquals(selector, selector, true);
        NodeSelector sel2 = new NodeSelector(KEY);
        ConfigurationAssert.checkEquals(selector, sel2, true);
        NodeSelector sub1 = selector.subSelector("k2");
        NodeSelector sub2 = sel2.subSelector("k2");
        ConfigurationAssert.checkEquals(sub1, sub2, true);
    }

    @Test
    public void testEqualsFalse() {
        NodeSelector selector = new NodeSelector(KEY);
        NodeSelector sel2 = new NodeSelector("othertables.testKey");
        ConfigurationAssert.checkEquals(selector, sel2, false);
        sel2 = new NodeSelector(KEY).subSelector(KEY);
        ConfigurationAssert.checkEquals(selector, sel2, false);
    }

    @Test
    public void testEqualsOtherObjects() {
        NodeSelector selector = new NodeSelector(KEY);
        ConfigurationAssert.checkEquals(selector, null, false);
        ConfigurationAssert.checkEquals(selector, this, false);
    }

    @Test
    public void testToString() {
        String key2 = "anotherSelectionKey";
        NodeSelector selector = new NodeSelector(KEY).subSelector("anotherSelectionKey");
        String s = selector.toString();
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)KEY));
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)"anotherSelectionKey"));
    }
}

