/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeAddData;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeMatcher;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDefaultExpressionEngine {
    private static String[] tables = new String[]{"users", "documents"};
    private static String[] tabTypes = new String[]{"system", "application"};
    private static String[][] fields = new String[][]{{"uid", "uname", "firstName", "lastName", "email"}, {"docid", "name", "creationDate", "authorID", "version"}};
    private static ImmutableNode root;
    private static NodeHandler<ImmutableNode> handler;
    private DefaultExpressionEngine engine;

    @BeforeClass
    public static void setUpBeforeClass() {
        root = TestDefaultExpressionEngine.setUpNodes();
        handler = new InMemoryNodeModel(root).getNodeHandler();
    }

    @Before
    public void setUp() throws Exception {
        this.engine = DefaultExpressionEngine.INSTANCE;
    }

    @Test
    public void testDefaultSymbols() {
        Assert.assertSame((String)"Wrong default symbols", (Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS, (Object)this.engine.getSymbols());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoSymbols() {
        new DefaultExpressionEngine(null);
    }

    @Test
    public void testQueryKeys() {
        this.checkKey("tables.table.name", "name", 2);
        this.checkKey("tables.table.fields.field.name", "name", 10);
        this.checkKey("tables.table[@type]", "type", 2);
        this.checkKey("tables.table(0).fields.field.name", "name", 5);
        this.checkKey("tables.table(1).fields.field.name", "name", 5);
        this.checkKey("tables.table.fields.field(1).name", "name", 2);
    }

    @Test
    public void testQueryNodes() {
        for (int i = 0; i < tables.length; ++i) {
            this.checkKeyValue("tables.table(" + i + ").name", "name", tables[i]);
            this.checkAttributeValue("tables.table(" + i + ")[@type]", "type", tabTypes[i]);
            for (int j = 0; j < fields[i].length; ++j) {
                this.checkKeyValue("tables.table(" + i + ").fields.field(" + j + ").name", "name", fields[i][j]);
            }
        }
    }

    @Test
    public void testQueryNonExistingKeys() {
        this.checkKey("tables.tablespace.name", null, 0);
        this.checkKey("tables.table(2).name", null, 0);
        this.checkKey("a complete unknown key", null, 0);
        this.checkKey("tables.table(0).fields.field(-1).name", null, 0);
        this.checkKey("tables.table(0).fields.field(28).name", null, 0);
        this.checkKey("tables.table(0).fields.field().name", null, 0);
        this.checkKey("connection.settings.usr.name", null, 0);
        this.checkKey("tables.table(0)[@type].additional", null, 0);
    }

    @Test
    public void testQueryEscapedKeys() {
        this.checkKeyValue("connection..settings.usr..name", "usr.name", "scott");
        this.checkKeyValue("connection..settings.usr..pwd", "usr.pwd", "tiger");
    }

    @Test
    public void testQueryAttributeEmulation() {
        DefaultExpressionEngineSymbols symbols = new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).setAttributeEnd(null).setAttributeStart(".").create();
        this.engine = new DefaultExpressionEngine(symbols);
        this.checkKeyValue("tables.table(0).name", "name", tables[0]);
        this.checkAttributeValue("tables.table(0).type", "type", tabTypes[0]);
        this.checkKey("tables.table.type", "type", 2);
    }

    private void checkQueryRootNode(String key) {
        List<QueryResult<ImmutableNode>> results = this.checkKey(key, null, 1);
        QueryResult<ImmutableNode> result = results.get(0);
        Assert.assertFalse((String)"No node result", (boolean)result.isAttributeResult());
        Assert.assertSame((String)"Not the root node", (Object)root, (Object)result.getNode());
    }

    @Test
    public void testQueryRootNodeNullKey() {
        this.checkQueryRootNode(null);
    }

    @Test
    public void testQueryRootNodeEmptyKey() {
        this.checkQueryRootNode("");
    }

    @Test
    public void testQueryRootAttribute() {
        this.checkAttributeValue("[@test]", "test", "true");
    }

    @Test
    public void testQueryAlternativeSyntax() {
        this.setUpAlternativeSyntax();
        this.checkKeyValue("tables/table[1]/name", "name", tables[1]);
        this.checkAttributeValue("tables/table[0]@type", "type", tabTypes[0]);
        this.checkAttributeValue("@test", "test", "true");
        this.checkKeyValue("connection.settings/usr.name", "usr.name", "scott");
    }

    @Test
    public void testNodeKey() {
        ImmutableNode node = (ImmutableNode)root.getChildren().get(0);
        Assert.assertEquals((String)"Invalid name for descendant of root", (Object)"tables", (Object)this.engine.nodeKey((Object)node, "", handler));
        Assert.assertEquals((String)"Parent key not respected", (Object)"test.tables", (Object)this.engine.nodeKey((Object)node, "test", handler));
        Assert.assertEquals((String)"Full parent key not taken into account", (Object)"a.full.parent.key.tables", (Object)this.engine.nodeKey((Object)node, "a.full.parent.key", handler));
    }

    @Test
    public void testNodeKeyWithRoot() {
        Assert.assertEquals((String)"Wrong name for root node", (Object)"", (Object)this.engine.nodeKey((Object)root, null, handler));
        Assert.assertEquals((String)"Null name not detected", (Object)"test", (Object)this.engine.nodeKey((Object)root, "test", handler));
    }

    @Test
    public void testAttributeKey() {
        Assert.assertEquals((String)"Wrong attribute key", (Object)"tables.table[@type]", (Object)this.engine.attributeKey("tables.table", "type"));
    }

    @Test
    public void testAttributeKeyRoot() {
        Assert.assertEquals((String)"Wrong key for root attribute", (Object)"[@test]", (Object)this.engine.attributeKey("", "test"));
    }

    @Test
    public void testAttributeKeyNoParent() {
        Assert.assertEquals((String)"Wrong key for null parent", (Object)"[@test]", (Object)this.engine.attributeKey(null, "test"));
    }

    @Test
    public void testNodeKeyWithEscapedDelimiters() {
        ImmutableNode node = (ImmutableNode)root.getChildren().get(1);
        Assert.assertEquals((String)"Wrong escaped key", (Object)"connection..settings", (Object)this.engine.nodeKey((Object)node, "", handler));
        Assert.assertEquals((String)"Wrong complex escaped key", (Object)"connection..settings.usr..name", (Object)this.engine.nodeKey(node.getChildren().get(0), this.engine.nodeKey((Object)node, "", handler), handler));
    }

    @Test
    public void testNodeKeyWithAlternativeSyntax() {
        this.setUpAlternativeSyntax();
        Assert.assertEquals((String)"Wrong child key", (Object)"tables/table", (Object)this.engine.nodeKey(((ImmutableNode)root.getChildren().get(0)).getChildren().get(0), "tables", handler));
    }

    @Test
    public void testAttributeKeyWithAlternativeSyntax() {
        this.setUpAlternativeSyntax();
        Assert.assertEquals((String)"Wrong attribute key", (Object)"@test", (Object)this.engine.attributeKey("", "test"));
    }

    @Test
    public void testNodeKeyWithAlternativeSyntaxAttributePropertyDelimiter() {
        this.setUpAlternativeSyntax();
        DefaultExpressionEngineSymbols symbols = new DefaultExpressionEngineSymbols.Builder(this.engine.getSymbols()).setAttributeStart(this.engine.getSymbols().getPropertyDelimiter()).create();
        this.engine = new DefaultExpressionEngine(symbols);
        Assert.assertEquals((String)"Wrong attribute key", (Object)"/test", (Object)this.engine.attributeKey("", "test"));
    }

    @Test
    public void testPrepareAddDirectly() {
        NodeAddData data = this.engine.prepareAdd((Object)root, "newNode", handler);
        Assert.assertSame((String)"Wrong parent node", (Object)root, (Object)data.getParent());
        Assert.assertTrue((String)"Path nodes available", (boolean)data.getPathNodes().isEmpty());
        Assert.assertEquals((String)"Wrong name of new node", (Object)"newNode", (Object)data.getNewNodeName());
        Assert.assertFalse((String)"New node is an attribute", (boolean)data.isAttribute());
        data = this.engine.prepareAdd((Object)root, "tables.table.fields.field.name", handler);
        Assert.assertEquals((String)"Wrong name of new node", (Object)"name", (Object)data.getNewNodeName());
        Assert.assertTrue((String)"Path nodes available", (boolean)data.getPathNodes().isEmpty());
        Assert.assertEquals((String)"Wrong parent node", (Object)"field", (Object)((ImmutableNode)data.getParent()).getNodeName());
        ImmutableNode nd = (ImmutableNode)((ImmutableNode)data.getParent()).getChildren().get(0);
        Assert.assertEquals((String)"Field has no name node", (Object)"name", (Object)nd.getNodeName());
        Assert.assertEquals((String)"Incorrect name", (Object)"version", (Object)nd.getValue());
    }

    @Test
    public void testPrepareAddWithIndex() {
        NodeAddData data = this.engine.prepareAdd((Object)root, "tables.table(0).tableSpace", handler);
        Assert.assertEquals((String)"Wrong name of new node", (Object)"tableSpace", (Object)data.getNewNodeName());
        Assert.assertTrue((String)"Path nodes available", (boolean)data.getPathNodes().isEmpty());
        Assert.assertEquals((String)"Wrong type of parent node", (Object)"table", (Object)((ImmutableNode)data.getParent()).getNodeName());
        ImmutableNode node = (ImmutableNode)((ImmutableNode)data.getParent()).getChildren().get(0);
        Assert.assertEquals((String)"Wrong table", (Object)tables[0], (Object)node.getValue());
        data = this.engine.prepareAdd((Object)root, "tables.table(1).fields.field(2).alias", handler);
        Assert.assertEquals((String)"Wrong name of new node", (Object)"alias", (Object)data.getNewNodeName());
        Assert.assertEquals((String)"Wrong type of parent node", (Object)"field", (Object)((ImmutableNode)data.getParent()).getNodeName());
        Assert.assertEquals((String)"Wrong field node", (Object)"creationDate", (Object)((ImmutableNode)((ImmutableNode)data.getParent()).getChildren().get(0)).getValue());
    }

    @Test
    public void testPrepareAddAttribute() {
        NodeAddData data = this.engine.prepareAdd((Object)root, "tables.table(0)[@tableSpace]", handler);
        Assert.assertEquals((String)"Wrong table node", (Object)tables[0], (Object)((ImmutableNode)((ImmutableNode)data.getParent()).getChildren().get(0)).getValue());
        Assert.assertEquals((String)"Wrong name of new node", (Object)"tableSpace", (Object)data.getNewNodeName());
        Assert.assertTrue((String)"Attribute not detected", (boolean)data.isAttribute());
        Assert.assertTrue((String)"Path nodes available", (boolean)data.getPathNodes().isEmpty());
    }

    @Test
    public void testPrepareAddAttributeRoot() {
        NodeAddData data = this.engine.prepareAdd((Object)root, "[@newAttr]", handler);
        Assert.assertSame((String)"Root node is not parent", (Object)root, (Object)data.getParent());
        Assert.assertEquals((String)"Wrong name of new node", (Object)"newAttr", (Object)data.getNewNodeName());
        Assert.assertTrue((String)"Attribute not detected", (boolean)data.isAttribute());
    }

    @Test
    public void testPrepareAddWithPath() {
        NodeAddData data = this.engine.prepareAdd((Object)root, "tables.table(1).fields.field(-1).name", handler);
        Assert.assertEquals((String)"Wrong name of new node", (Object)"name", (Object)data.getNewNodeName());
        this.checkNodePath((NodeAddData<ImmutableNode>)data, "field");
        Assert.assertEquals((String)"Wrong type of parent node", (Object)"fields", (Object)((ImmutableNode)data.getParent()).getNodeName());
        data = this.engine.prepareAdd((Object)root, "tables.table(-1).name", handler);
        Assert.assertEquals((String)"Wrong name of new node", (Object)"name", (Object)data.getNewNodeName());
        this.checkNodePath((NodeAddData<ImmutableNode>)data, "table");
        Assert.assertEquals((String)"Wrong type of parent node", (Object)"tables", (Object)((ImmutableNode)data.getParent()).getNodeName());
        data = this.engine.prepareAdd((Object)root, "a.complete.new.path", handler);
        Assert.assertEquals((String)"Wrong name of new node", (Object)"path", (Object)data.getNewNodeName());
        this.checkNodePath((NodeAddData<ImmutableNode>)data, "a", "complete", "new");
        Assert.assertSame((String)"Root is not parent", (Object)root, (Object)data.getParent());
    }

    @Test
    public void testPrepareAddWithSameAttributeDelimiter() {
        DefaultExpressionEngineSymbols symbols = new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).setAttributeEnd(null).setAttributeStart(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getPropertyDelimiter()).create();
        this.engine = new DefaultExpressionEngine(symbols);
        NodeAddData data = this.engine.prepareAdd((Object)root, "tables.table(0).test", handler);
        Assert.assertEquals((String)"Wrong name of new node", (Object)"test", (Object)data.getNewNodeName());
        Assert.assertFalse((String)"New node is an attribute", (boolean)data.isAttribute());
        Assert.assertEquals((String)"Wrong type of parent node", (Object)"table", (Object)((ImmutableNode)data.getParent()).getNodeName());
        data = this.engine.prepareAdd((Object)root, "a.complete.new.path", handler);
        Assert.assertFalse((String)"New node is an attribute", (boolean)data.isAttribute());
        this.checkNodePath((NodeAddData<ImmutableNode>)data, "a", "complete", "new");
    }

    @Test
    public void testPrepareAddWithAlternativeSyntax() {
        this.setUpAlternativeSyntax();
        NodeAddData data = this.engine.prepareAdd((Object)root, "tables/table[0]/test", handler);
        Assert.assertEquals((String)"Wrong name of new node", (Object)"test", (Object)data.getNewNodeName());
        Assert.assertFalse((String)"New node is attribute", (boolean)data.isAttribute());
        Assert.assertEquals((String)"Wrong parent node", (Object)tables[0], (Object)((ImmutableNode)((ImmutableNode)data.getParent()).getChildren().get(0)).getValue());
        data = this.engine.prepareAdd((Object)root, "a/complete/new/path@attr", handler);
        Assert.assertEquals((String)"Wrong name of new attribute", (Object)"attr", (Object)data.getNewNodeName());
        this.checkNodePath((NodeAddData<ImmutableNode>)data, "a", "complete", "new", "path");
        Assert.assertSame((String)"Root is not parent", (Object)root, (Object)data.getParent());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidKey() {
        this.engine.prepareAdd((Object)root, "tables.table(0)[@type].new", handler);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidKeyAttribute() {
        this.engine.prepareAdd((Object)root, "a.complete.new.path.with.an[@attribute].at.a.non.allowed[@position]", handler);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddNullKey() {
        this.engine.prepareAdd((Object)root, null, handler);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddEmptyKey() {
        this.engine.prepareAdd((Object)root, "", handler);
    }

    @Test
    public void testCanonicalKeyNoDuplicates() {
        ImmutableNode node = this.fetchNode("tables.table(0).name");
        Assert.assertEquals((String)"Wrong canonical key", (Object)"table.name(0)", (Object)this.engine.canonicalKey((Object)node, "table", handler));
    }

    @Test
    public void testCanonicalKeyWithDuplicates() {
        ImmutableNode tab1 = this.fetchNode("tables.table(0)");
        ImmutableNode tab2 = this.fetchNode("tables.table(1)");
        Assert.assertEquals((String)"Wrong key 1", (Object)"tables.table(0)", (Object)this.engine.canonicalKey((Object)tab1, "tables", handler));
        Assert.assertEquals((String)"Wrong key 2", (Object)"tables.table(1)", (Object)this.engine.canonicalKey((Object)tab2, "tables", handler));
    }

    @Test
    public void testCanonicalKeyNoParentKey() {
        ImmutableNode node = this.fetchNode("tables.table(0).fields.field(1).name");
        Assert.assertEquals((String)"Wrong key", (Object)"name(0)", (Object)this.engine.canonicalKey((Object)node, null, handler));
    }

    @Test
    public void testCanonicalKeyRootNoParentKey() {
        Assert.assertEquals((String)"Wrong key", (Object)"", (Object)this.engine.canonicalKey((Object)root, null, handler));
    }

    @Test
    public void testCanonicalKeyRootWithParentKey() {
        Assert.assertEquals((String)"Wrong key", (Object)"parent", (Object)this.engine.canonicalKey((Object)root, "parent", handler));
    }

    @Test
    public void testQueryKeyWithAlternativeMatcher() {
        this.setUpAlternativeMatcher();
        this.checkKey("tables_._table_.name_", "name", 2);
    }

    @Test
    public void testPrepareAddWithAlternativeMatcher() {
        this.setUpAlternativeMatcher();
        NodeAddData data = this.engine.prepareAdd((Object)root, "tables_.table._fields__._field.name", handler);
        Assert.assertEquals((String)"Wrong name of new node", (Object)"name", (Object)data.getNewNodeName());
        Assert.assertTrue((String)"Path nodes available", (boolean)data.getPathNodes().isEmpty());
    }

    private static ImmutableNode setUpNodes() {
        ImmutableNode.Builder nodeTablesBuilder = new ImmutableNode.Builder(tables.length);
        nodeTablesBuilder.name("tables");
        for (int i = 0; i < tables.length; ++i) {
            ImmutableNode.Builder nodeTableBuilder = new ImmutableNode.Builder(2);
            nodeTableBuilder.name("table");
            nodeTableBuilder.addChild(new ImmutableNode.Builder().name("name").value((Object)tables[i]).create());
            nodeTableBuilder.addAttribute("type", (Object)tabTypes[i]);
            ImmutableNode.Builder nodeFieldsBuilder = new ImmutableNode.Builder(fields[i].length);
            for (int j = 0; j < fields[i].length; ++j) {
                nodeFieldsBuilder.addChild(TestDefaultExpressionEngine.createFieldNode(fields[i][j]));
            }
            nodeTableBuilder.addChild(nodeFieldsBuilder.name("fields").create());
            nodeTablesBuilder.addChild(nodeTableBuilder.create());
        }
        ImmutableNode.Builder rootBuilder = new ImmutableNode.Builder();
        rootBuilder.addChild(nodeTablesBuilder.create());
        ImmutableNode.Builder nodeConnBuilder = new ImmutableNode.Builder();
        nodeConnBuilder.name("connection.settings");
        nodeConnBuilder.addChild(TestDefaultExpressionEngine.createNode("usr.name", "scott"));
        nodeConnBuilder.addChild(TestDefaultExpressionEngine.createNode("usr.pwd", "tiger"));
        rootBuilder.addAttribute("test", (Object)"true");
        rootBuilder.addChild(nodeConnBuilder.create());
        return rootBuilder.create();
    }

    private void setUpAlternativeSyntax() {
        DefaultExpressionEngineSymbols symbols = new DefaultExpressionEngineSymbols.Builder().setAttributeEnd(null).setAttributeStart("@").setPropertyDelimiter("/").setEscapedDelimiter(null).setIndexStart("[").setIndexEnd("]").create();
        this.engine = new DefaultExpressionEngine(symbols);
    }

    private void setUpAlternativeMatcher() {
        NodeMatcher<String> matcher = new NodeMatcher<String>(){

            public <T> boolean matches(T node, NodeHandler<T> handler, String criterion) {
                return handler.nodeName(node).equals(StringUtils.remove((String)criterion, (char)'_'));
            }
        };
        this.engine = new DefaultExpressionEngine(this.engine.getSymbols(), (NodeMatcher)matcher);
    }

    private List<QueryResult<ImmutableNode>> checkKey(String key, String name, int count) {
        List<QueryResult<ImmutableNode>> nodes = this.query(key, count);
        for (QueryResult<ImmutableNode> result : nodes) {
            if (result.isAttributeResult()) {
                Assert.assertEquals((String)("Wrong attribute name for key " + key), (Object)name, (Object)result.getAttributeName());
                continue;
            }
            Assert.assertEquals((String)("Wrong result node for key " + key), (Object)name, (Object)((ImmutableNode)result.getNode()).getNodeName());
        }
        return nodes;
    }

    private List<QueryResult<ImmutableNode>> query(String key, int expCount) {
        List nodes = this.engine.query((Object)root, key, handler);
        Assert.assertEquals((String)("Wrong number of result nodes for key " + key), (long)expCount, (long)nodes.size());
        return nodes;
    }

    private ImmutableNode fetchNode(String key) {
        QueryResult<ImmutableNode> result = this.query(key, 1).get(0);
        Assert.assertFalse((String)"An attribute result", (boolean)result.isAttributeResult());
        return (ImmutableNode)result.getNode();
    }

    private void checkKeyValue(String key, String name, String value) {
        List<QueryResult<ImmutableNode>> results = this.checkKey(key, name, 1);
        QueryResult<ImmutableNode> result = results.get(0);
        Assert.assertFalse((String)"No node result", (boolean)result.isAttributeResult());
        Assert.assertEquals((String)("Wrong value for key " + key), (Object)value, (Object)((ImmutableNode)result.getNode()).getValue());
    }

    private void checkAttributeValue(String key, String attr, Object expValue) {
        List<QueryResult<ImmutableNode>> results = this.checkKey(key, attr, 1);
        QueryResult<ImmutableNode> result = results.get(0);
        Assert.assertTrue((String)"Not an attribute result", (boolean)result.isAttributeResult());
        Assert.assertEquals((String)("Wrong attribute value for key " + key), (Object)expValue, (Object)result.getAttributeValue(handler));
    }

    private void checkNodePath(NodeAddData<ImmutableNode> data, String ... expected) {
        Assert.assertEquals((String)"Wrong number of path nodes", (long)expected.length, (long)data.getPathNodes().size());
        Iterator it = data.getPathNodes().iterator();
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("Wrong path node " + i), (Object)expected[i], it.next());
        }
    }

    private static ImmutableNode createFieldNode(String name) {
        ImmutableNode.Builder nodeFieldBuilder = new ImmutableNode.Builder(1);
        nodeFieldBuilder.addChild(TestDefaultExpressionEngine.createNode("name", name));
        return nodeFieldBuilder.name("field").create();
    }

    private static ImmutableNode createNode(String name, Object value) {
        return new ImmutableNode.Builder().name(name).value(value).create();
    }
}

