/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.plist;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import junitx.framework.ArrayAssert;
import junitx.framework.ListAssert;
import junitx.framework.ObjectAssert;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.StrictConfigurationComparator;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.plist.XMLPropertyListConfiguration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestXMLPropertyListConfiguration {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private XMLPropertyListConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(this.config, ConfigurationAssert.getTestFile("test.plist.xml"));
    }

    private static void load(XMLPropertyListConfiguration c, File file) throws ConfigurationException {
        new FileHandler((FileBased)c).load(file);
    }

    private void save(File file) throws ConfigurationException {
        new FileHandler((FileBased)this.config).save(file);
    }

    @Test
    public void testString() throws Exception {
        Assert.assertEquals((String)"'string' property", (Object)"value1", (Object)this.config.getString("string"));
    }

    @Test
    public void testInteger() throws Exception {
        Assert.assertEquals((String)"'integer' property", (long)12345678900L, (long)this.config.getLong("integer"));
    }

    @Test
    public void testReal() throws Exception {
        Assert.assertEquals((String)"'real' property", (double)-12.345, (double)this.config.getDouble("real"), (double)0.0);
    }

    @Test
    public void testBoolean() throws Exception {
        Assert.assertEquals((String)"'boolean1' property", (Object)true, (Object)this.config.getBoolean("boolean1"));
        Assert.assertEquals((String)"'boolean2' property", (Object)false, (Object)this.config.getBoolean("boolean2"));
    }

    @Test
    public void testDictionary() {
        Assert.assertEquals((String)"1st element", (Object)"value1", (Object)this.config.getProperty("dictionary.key1"));
        Assert.assertEquals((String)"2nd element", (Object)"value2", (Object)this.config.getProperty("dictionary.key2"));
        Assert.assertEquals((String)"3rd element", (Object)"value3", (Object)this.config.getProperty("dictionary.key3"));
    }

    @Test
    public void testDate() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.set(2005, 0, 1, 12, 0, 0);
        Assert.assertEquals((String)"'date' property", (Object)calendar.getTime(), (Object)this.config.getProperty("date"));
        calendar.setTimeZone(TimeZone.getTimeZone("CET"));
        calendar.set(2002, 2, 22, 11, 30, 0);
        Assert.assertEquals((String)"'date-gnustep' property", (Object)calendar.getTime(), (Object)this.config.getProperty("date-gnustep"));
    }

    @Test
    public void testSubset() {
        Configuration subset = this.config.subset("dictionary");
        Iterator keys = subset.getKeys();
        String key = (String)keys.next();
        Assert.assertEquals((String)"1st key", (Object)"key1", (Object)key);
        Assert.assertEquals((String)"1st value", (Object)"value1", (Object)subset.getString(key));
        key = (String)keys.next();
        Assert.assertEquals((String)"2nd key", (Object)"key2", (Object)key);
        Assert.assertEquals((String)"2nd value", (Object)"value2", (Object)subset.getString(key));
        key = (String)keys.next();
        Assert.assertEquals((String)"3rd key", (Object)"key3", (Object)key);
        Assert.assertEquals((String)"3rd value", (Object)"value3", (Object)subset.getString(key));
        Assert.assertFalse((String)"more than 3 properties founds", (boolean)keys.hasNext());
    }

    @Test
    public void testArray() {
        Object array = this.config.getProperty("array");
        Assert.assertNotNull((String)"array not found", (Object)array);
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, (Object)array);
        List list = this.config.getList("array");
        Assert.assertFalse((String)"empty array", (boolean)list.isEmpty());
        Assert.assertEquals((String)"size", (long)3L, (long)list.size());
        Assert.assertEquals((String)"1st element", (Object)"value1", list.get(0));
        Assert.assertEquals((String)"2nd element", (Object)"value2", list.get(1));
        Assert.assertEquals((String)"3rd element", (Object)"value3", list.get(2));
    }

    @Test
    public void testNestedArray() {
        String key = "nested-array";
        Object array = this.config.getProperty(key);
        Assert.assertNotNull((String)"array not found", (Object)array);
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, (Object)array);
        List list = this.config.getList(key);
        Assert.assertFalse((String)"empty array", (boolean)list.isEmpty());
        Assert.assertEquals((String)"size", (long)2L, (long)list.size());
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, list.get(0));
        List list1 = (List)list.get(0);
        Assert.assertFalse((String)"nested array 1 is empty", (boolean)list1.isEmpty());
        Assert.assertEquals((String)"size", (long)2L, (long)list1.size());
        Assert.assertEquals((String)"1st element", (Object)"a", list1.get(0));
        Assert.assertEquals((String)"2nd element", (Object)"b", list1.get(1));
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, list.get(1));
        List list2 = (List)list.get(1);
        Assert.assertFalse((String)"nested array 2 is empty", (boolean)list2.isEmpty());
        Assert.assertEquals((String)"size", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"1st element", (Object)"c", list2.get(0));
        Assert.assertEquals((String)"2nd element", (Object)"d", list2.get(1));
    }

    @Test
    public void testDictionaryArray() {
        String key = "dictionary-array";
        Object array = this.config.getProperty(key);
        Assert.assertNotNull((String)"array not found", (Object)array);
        ObjectAssert.assertInstanceOf((String)"the array element is not parsed as a List", List.class, (Object)array);
        List list = this.config.getList(key);
        Assert.assertFalse((String)"empty array", (boolean)list.isEmpty());
        Assert.assertEquals((String)"size", (long)2L, (long)list.size());
        ObjectAssert.assertInstanceOf((String)"the dict element is not parsed as a Configuration", Configuration.class, list.get(0));
        Configuration conf1 = (Configuration)list.get(0);
        Assert.assertFalse((String)"configuration 1 is empty", (boolean)conf1.isEmpty());
        Assert.assertEquals((String)"configuration element", (Object)"bar", (Object)conf1.getProperty("foo"));
        ObjectAssert.assertInstanceOf((String)"the dict element is not parsed as a Configuration", Configuration.class, list.get(1));
        Configuration conf2 = (Configuration)list.get(1);
        Assert.assertFalse((String)"configuration 2 is empty", (boolean)conf2.isEmpty());
        Assert.assertEquals((String)"configuration element", (Object)"value", (Object)conf2.getProperty("key"));
    }

    @Test
    public void testNested() {
        Assert.assertEquals((String)"nested property", (Object)"value", (Object)this.config.getString("nested.node1.node2.node3"));
    }

    @Test
    public void testSave() throws Exception {
        File savedFile = this.folder.newFile();
        this.save(savedFile);
        Assert.assertTrue((String)"The saved file doesn't exist", (boolean)savedFile.exists());
        XMLPropertyListConfiguration checkConfig = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(checkConfig, savedFile);
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertTrue((String)("The saved configuration doesn't contain the key '" + key + "'"), (boolean)checkConfig.containsKey(key));
            Object value = checkConfig.getProperty(key);
            if (value instanceof byte[]) {
                byte[] array = (byte[])value;
                ArrayAssert.assertEquals((String)("Value of the '" + key + "' property"), (byte[])((byte[])this.config.getProperty(key)), (byte[])array);
                continue;
            }
            if (value instanceof List) {
                List list1 = (List)this.config.getProperty(key);
                List list2 = (List)value;
                Assert.assertEquals((String)("The size of the list for the key '" + key + "' doesn't match"), (long)list1.size(), (long)list2.size());
                for (int i = 0; i < list2.size(); ++i) {
                    Object value1 = list1.get(i);
                    Object value2 = list2.get(i);
                    if (value1 instanceof Configuration) {
                        StrictConfigurationComparator comparator = new StrictConfigurationComparator();
                        Assert.assertTrue((String)("The dictionnary at index " + i + " for the key '" + key + "' doesn't match"), (boolean)comparator.compare((Configuration)value1, (Configuration)value2));
                        continue;
                    }
                    Assert.assertEquals((String)("Element at index " + i + " for the key '" + key + "'"), value1, value2);
                }
                ListAssert.assertEquals((String)("Value of the '" + key + "' property"), (List)((List)this.config.getProperty(key)), (List)list1);
                continue;
            }
            Assert.assertEquals((String)("Value of the '" + key + "' property"), (Object)this.config.getProperty(key), (Object)checkConfig.getProperty(key));
        }
    }

    @Test
    public void testSaveEmptyDictionary() throws Exception {
        File savedFile = this.folder.newFile();
        this.save(savedFile);
        Assert.assertTrue((String)"The saved file doesn't exist", (boolean)savedFile.exists());
        XMLPropertyListConfiguration checkConfig = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(checkConfig, savedFile);
        Assert.assertEquals(null, (Object)this.config.getProperty("empty-dictionary"));
        Assert.assertEquals(null, (Object)checkConfig.getProperty("empty-dictionary"));
    }

    @Test
    public void testSetDataProperty() throws Exception {
        File savedFile = this.folder.newFile();
        byte[] expected = new byte[]{1, 2, 3, 4};
        this.config = new XMLPropertyListConfiguration();
        this.config.setProperty("foo", (Object)expected);
        this.save(savedFile);
        XMLPropertyListConfiguration config2 = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(config2, savedFile);
        Object array = config2.getProperty("foo");
        Assert.assertNotNull((String)"data not found", (Object)array);
        Assert.assertEquals((String)"property type", byte[].class, array.getClass());
        ArrayAssert.assertEquals((byte[])expected, (byte[])((byte[])array));
    }

    @Test
    public void testAddDataProperty() throws Exception {
        File savedFile = this.folder.newFile();
        byte[] expected = new byte[]{1, 2, 3, 4};
        this.config = new XMLPropertyListConfiguration();
        this.config.addProperty("foo", (Object)expected);
        this.save(savedFile);
        XMLPropertyListConfiguration config2 = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(config2, savedFile);
        Object array = config2.getProperty("foo");
        Assert.assertNotNull((String)"data not found", (Object)array);
        Assert.assertEquals((String)"property type", byte[].class, array.getClass());
        ArrayAssert.assertEquals((byte[])expected, (byte[])((byte[])array));
    }

    @Test
    public void testInitCopy() {
        XMLPropertyListConfiguration copy = new XMLPropertyListConfiguration((HierarchicalConfiguration)this.config);
        StrictConfigurationComparator comp = new StrictConfigurationComparator();
        Assert.assertTrue((String)"Configurations are not equal", (boolean)comp.compare((Configuration)this.config, (Configuration)copy));
    }

    @Test
    public void testLoadNoDict() throws ConfigurationException {
        XMLPropertyListConfiguration plist = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(plist, ConfigurationAssert.getTestFile("test2.plist.xml"));
        Assert.assertFalse((String)"Configuration is empty", (boolean)plist.isEmpty());
    }

    @Test
    public void testLoadNoDictConstr() throws ConfigurationException {
        XMLPropertyListConfiguration plist = new XMLPropertyListConfiguration();
        TestXMLPropertyListConfiguration.load(plist, ConfigurationAssert.getTestFile("test2.plist.xml"));
        Assert.assertFalse((String)"Configuration is empty", (boolean)plist.isEmpty());
    }

    @Test
    public void testSetDatePropertyInvalid() throws ConfigurationException {
        this.config.clear();
        TestXMLPropertyListConfiguration.load(this.config, ConfigurationAssert.getTestFile("test_invalid_date.plist.xml"));
        Assert.assertEquals((String)"'string' property", (Object)"value1", (Object)this.config.getString("string"));
        Assert.assertFalse((String)"Date property was loaded", (boolean)this.config.containsKey("date"));
    }

    @Test
    public void testSaveNoEncoding() throws ConfigurationException {
        StringWriter writer = new StringWriter();
        new FileHandler((FileBased)this.config).save((Writer)writer);
        Assert.assertTrue((String)"Wrong document header", (writer.toString().indexOf("<?xml version=\"1.0\"?>") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSaveWithEncoding() throws ConfigurationException {
        String encoding = "UTF-8";
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.setEncoding(encoding);
        StringWriter writer = new StringWriter();
        handler.save((Writer)writer);
        Assert.assertTrue((String)"Encoding not found", (writer.toString().indexOf("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>") >= 0 ? 1 : 0) != 0);
    }

    private void checkArrayProperty(List<?> expectedValues) throws ConfigurationException {
        StringWriter out = new StringWriter();
        new FileHandler((FileBased)this.config).save((Writer)out);
        StringBuilder values = new StringBuilder();
        for (Object v : expectedValues) {
            values.append("<string>").append(v).append("</string>");
        }
        String content = out.toString().replaceAll("[ \n\r]", "");
        Assert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)String.format("<key>array</key><array>%s</array>", values)));
    }

    @Test
    public void testSaveList() throws ConfigurationException {
        List<String> elems = Arrays.asList("element1", "element2", "anotherElement");
        this.config = new XMLPropertyListConfiguration();
        this.config.addProperty("array", elems);
        this.checkArrayProperty(elems);
    }

    @Test
    public void testSaveArray() throws ConfigurationException {
        Object[] elems = new Object[]{"arrayElem1", "arrayElem2", "arrayElem3"};
        this.config = new XMLPropertyListConfiguration();
        this.config.addProperty("array", (Object)elems);
        this.checkArrayProperty(Arrays.asList(elems));
    }

    @Test
    public void testWriteCalledDirectly() throws IOException {
        this.config = new XMLPropertyListConfiguration();
        this.config.addProperty("foo", (Object)"bar");
        try (FileWriter out = new FileWriter(this.folder.newFile());){
            this.config.write((Writer)out);
            Assert.fail((String)"No exception thrown!");
        }
    }
}

