/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.interpol;

import java.awt.event.KeyEvent;
import org.apache.commons.configuration2.interpol.ConstantLookup;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConstantLookup {
    public static final String FIELD = "Field that can be read";
    private static final String PRIVATE_FIELD = "PRIVATE";
    private ConstantLookup lookup;

    @Before
    public void setUp() throws Exception {
        this.lookup = new ConstantLookup();
    }

    private String variable(String field) {
        return this.getClass().getName() + '.' + field;
    }

    @After
    public void tearDown() throws Exception {
        ConstantLookup.clear();
    }

    @Test
    public void testLookupConstant() {
        Assert.assertEquals((String)"Wrong value of constant", (Object)FIELD, (Object)this.lookup.lookup(this.variable("FIELD")));
    }

    @Test
    public void testLookupNonExisting() {
        Assert.assertNull((String)"Non null return value for non existing constant", (Object)this.lookup.lookup(this.variable("NO_FIELD")));
    }

    @Test
    public void testLookupPrivate() {
        Assert.assertNull((String)"Non null return value for non accessible field", (Object)this.lookup.lookup(this.variable("PRIVATE_FIELD")));
    }

    @Test
    public void testLookupUnknownClass() {
        Assert.assertNull((String)"Non null return value for unknown class", (Object)this.lookup.lookup("org.apache.commons.configuration.NonExistingConfig.Field that can be read"));
    }

    @Test
    public void testLookupInvalidSyntax() {
        Assert.assertNull((String)"Non null return value for invalid variable name", (Object)this.lookup.lookup("InvalidVariableName"));
    }

    @Test
    public void testLookupNull() {
        Assert.assertNull((String)"Non null return value for null variable", (Object)this.lookup.lookup(null));
    }

    @Test
    public void testLookupCache() {
        this.testLookupConstant();
        this.testLookupConstant();
    }

    @Test
    public void testLookupNonStringFromCache() {
        String var = KeyEvent.class.getName() + ".VK_ESCAPE";
        Integer expected = 27;
        Assert.assertEquals((String)"Wrong result of first lookup", (Object)expected, (Object)this.lookup.lookup(var));
        Assert.assertEquals((String)"Wrong result of 2nd lookup", (Object)expected, (Object)this.lookup.lookup(var));
    }
}

