/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.convert;

import java.lang.annotation.ElementType;
import java.math.BigDecimal;
import org.apache.commons.configuration2.convert.DefaultConversionHandler;
import org.apache.commons.configuration2.convert.PropertyConverter;
import org.apache.commons.configuration2.ex.ConversionException;
import org.junit.Assert;
import org.junit.Test;

public class TestPropertyConverter {
    private static final Class<ElementType> ENUM_CLASS = ElementType.class;

    @Test
    public void testToNumberDirect() {
        Integer i = new Integer(42);
        Assert.assertSame((String)"Wrong integer", (Object)i, (Object)PropertyConverter.toNumber((Object)i, Integer.class));
        BigDecimal d = new BigDecimal("3.1415");
        Assert.assertSame((String)"Wrong BigDecimal", (Object)d, (Object)PropertyConverter.toNumber((Object)d, Integer.class));
    }

    @Test
    public void testToNumberFromString() {
        Assert.assertEquals((String)"Incorrect Integer value", (Object)new Integer(42), (Object)PropertyConverter.toNumber((Object)"42", Integer.class));
        Assert.assertEquals((String)"Incorrect Short value", (Object)new Short(10), (Object)PropertyConverter.toNumber((Object)new StringBuffer("10"), Short.class));
    }

    @Test
    public void testToNumberFromHexString() {
        Number n = PropertyConverter.toNumber((Object)"0x10", Integer.class);
        Assert.assertEquals((String)"Incorrect Integer value", (long)16L, (long)n.intValue());
    }

    @Test(expected=ConversionException.class)
    public void testToNumberFromInvalidHexString() {
        PropertyConverter.toNumber((Object)"0xNotAHexValue", Integer.class);
    }

    @Test
    public void testToNumberFromBinaryString() {
        Number n = PropertyConverter.toNumber((Object)"0b1111", Integer.class);
        Assert.assertEquals((String)"Incorrect Integer value", (long)15L, (long)n.intValue());
    }

    @Test(expected=ConversionException.class)
    public void testToNumberFromInvalidBinaryString() {
        PropertyConverter.toNumber((Object)"0bNotABinValue", Integer.class);
    }

    @Test(expected=ConversionException.class)
    public void testToNumberFromInvalidString() {
        PropertyConverter.toNumber((Object)"Not a number", Byte.class);
    }

    @Test(expected=ConversionException.class)
    public void testToNumberWithInvalidClass() {
        PropertyConverter.toNumber((Object)"42", Object.class);
    }

    @Test
    public void testToEnumFromEnum() {
        Assert.assertEquals((Object)((Object)ElementType.METHOD), (Object)PropertyConverter.toEnum((Object)((Object)ElementType.METHOD), ENUM_CLASS));
    }

    @Test
    public void testToEnumFromString() {
        Assert.assertEquals((Object)((Object)ElementType.METHOD), (Object)PropertyConverter.toEnum((Object)"METHOD", ENUM_CLASS));
    }

    @Test(expected=ConversionException.class)
    public void testToEnumFromInvalidString() {
        PropertyConverter.toEnum((Object)"FOO", ENUM_CLASS);
    }

    @Test
    public void testToEnumFromNumber() {
        Assert.assertEquals((Object)((Object)ElementType.METHOD), (Object)PropertyConverter.toEnum((Object)ElementType.METHOD.ordinal(), ENUM_CLASS));
    }

    @Test(expected=ConversionException.class)
    public void testToEnumFromInvalidNumber() {
        PropertyConverter.toEnum((Object)-1, ENUM_CLASS);
    }

    @Test
    public void testToNoConversionNeeded() {
        String value = "testValue";
        Assert.assertEquals((String)"Wrong conversion result", (Object)value, (Object)PropertyConverter.to(String.class, (Object)value, (DefaultConversionHandler)new DefaultConversionHandler()));
    }

    @Test
    public void testToCharSuccess() {
        Assert.assertEquals((String)"Wrong conversion result", (Object)Character.valueOf('t'), (Object)PropertyConverter.to(Character.class, (Object)"t", (DefaultConversionHandler)new DefaultConversionHandler()));
    }

    @Test
    public void testToCharViaToString() {
        Object value = new Object(){

            public String toString() {
                return "X";
            }
        };
        Assert.assertEquals((String)"Wrong conversion result", (Object)Character.valueOf('X'), (Object)PropertyConverter.to(Character.TYPE, (Object)value, (DefaultConversionHandler)new DefaultConversionHandler()));
    }

    @Test(expected=ConversionException.class)
    public void testToCharFailed() {
        PropertyConverter.to(Character.TYPE, (Object)"FF", (DefaultConversionHandler)new DefaultConversionHandler());
    }

    @Test
    public void testToStringConversion() {
        Integer src = 42;
        Object result = PropertyConverter.to(String.class, (Object)src, (DefaultConversionHandler)new DefaultConversionHandler());
        Assert.assertEquals((String)"Wrong resulting string", (Object)"42", (Object)result);
    }
}

