/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.combined.MultiFileBuilderParametersImpl;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.DefaultLookups;
import org.junit.After;

public class AbstractMultiFileConfigurationBuilderTest {
    private static final String PROP = "Id";
    protected static String PATTERN_VAR = "${sys:Id}";
    protected static String PATTERN = "target/test-classes/testMultiConfiguration_" + PATTERN_VAR + ".xml";

    protected static void switchToConfig(String id) {
        if (id != null) {
            System.setProperty(PROP, id);
        } else {
            System.getProperties().remove(PROP);
        }
    }

    @After
    public void tearDown() throws Exception {
        AbstractMultiFileConfigurationBuilderTest.switchToConfig(null);
    }

    protected static void switchToConfig(int index) {
        AbstractMultiFileConfigurationBuilderTest.switchToConfig("100" + index);
    }

    protected static ConfigurationInterpolator createInterpolator() {
        ConfigurationInterpolator ci = new ConfigurationInterpolator();
        ci.registerLookup(DefaultLookups.SYSTEM_PROPERTIES.getPrefix(), DefaultLookups.SYSTEM_PROPERTIES.getLookup());
        return ci;
    }

    protected static BasicBuilderParameters createTestBuilderParameters(BuilderParameters managedParams) {
        return new MultiFileBuilderParametersImpl().setFilePattern(PATTERN).setManagedBuilderParameters(managedParams).setInterpolator(AbstractMultiFileConfigurationBuilderTest.createInterpolator());
    }
}

