/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.JSONConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJSONConfiguration {
    private String testJson = ConfigurationAssert.getTestFile("test.json").getAbsolutePath();
    private JSONConfiguration jsonConfiguration;

    @Before
    public void setUp() throws Exception {
        this.jsonConfiguration = new JSONConfiguration();
        this.jsonConfiguration.read((Reader)new FileReader(this.testJson));
    }

    @Test
    public void testGetProperty_simple() {
        Assert.assertEquals((Object)"value1", (Object)this.jsonConfiguration.getProperty("key1"));
    }

    @Test
    public void testGetProperty_nested() {
        Assert.assertEquals((Object)"value23", (Object)this.jsonConfiguration.getProperty("key2.key3"));
    }

    @Test
    public void testGetProperty_nested_with_list() {
        Assert.assertEquals(Arrays.asList("col1", "col2"), (Object)this.jsonConfiguration.getProperty("key4.key5"));
    }

    @Test
    public void testGetProperty_subset() {
        Configuration subset = this.jsonConfiguration.subset("key4");
        Assert.assertEquals(Arrays.asList("col1", "col2"), (Object)subset.getProperty("key5"));
    }

    @Test
    public void testGetProperty_very_nested_properties() {
        Object property = this.jsonConfiguration.getProperty("very.nested.properties");
        Assert.assertEquals(Arrays.asList("nested1", "nested2", "nested3"), (Object)property);
    }

    @Test
    public void testGetProperty_integer() {
        Object property = this.jsonConfiguration.getProperty("int1");
        Assert.assertTrue((String)"property should be an Integer", (boolean)(property instanceof Integer));
        Assert.assertEquals((Object)37, (Object)property);
    }

    @Test
    public void testSave() throws IOException, ConfigurationException {
        StringWriter sw = new StringWriter();
        this.jsonConfiguration.write((Writer)sw);
        String output = sw.toString();
        ObjectMapper mapper = new ObjectMapper();
        MapType type = mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
        Map parsed = (Map)mapper.readValue(output, (JavaType)type);
        Assert.assertEquals((long)6L, (long)parsed.entrySet().size());
        Assert.assertEquals((Object)"value1", parsed.get("key1"));
        Map key2 = (Map)parsed.get("key2");
        Assert.assertEquals((Object)"value23", key2.get("key3"));
        List key5 = (List)((Map)parsed.get("key4")).get("key5");
        Assert.assertEquals((long)2L, (long)key5.size());
        Assert.assertEquals((Object)"col1", key5.get(0));
        Assert.assertEquals((Object)"col2", key5.get(1));
    }

    @Test
    public void testGetProperty_dictionary() {
        Assert.assertEquals((Object)"Martin D'vloper", (Object)this.jsonConfiguration.getProperty("martin.name"));
        Assert.assertEquals((Object)"Developer", (Object)this.jsonConfiguration.getProperty("martin.job"));
        Assert.assertEquals((Object)"Elite", (Object)this.jsonConfiguration.getProperty("martin.skill"));
    }

    @Test
    public void testCopyConstructor() {
        BaseHierarchicalConfiguration c = new BaseHierarchicalConfiguration();
        c.addProperty("foo", (Object)"bar");
        this.jsonConfiguration = new JSONConfiguration((HierarchicalConfiguration)c);
        Assert.assertEquals((Object)"bar", (Object)this.jsonConfiguration.getString("foo"));
    }
}

