/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.resolver.CatalogResolver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.EntityResolver;

public class TestCatalogResolver {
    private static final String CATALOG_FILES = "catalog.xml";
    private static final String PUBLIC_FILE = "testResolver.xml";
    private static final String REWRITE_SYSTEM_FILE = "test.properties.xml";
    private static final String REWRITE_SCHEMA_FILE = "sample.xml";
    private CatalogResolver resolver;
    private XMLConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.resolver = new CatalogResolver();
        this.resolver.setCatalogFiles(CATALOG_FILES);
        this.config = new XMLConfiguration();
        this.config.setEntityResolver((EntityResolver)this.resolver);
    }

    @After
    public void tearDown() throws Exception {
        this.resolver = null;
        this.config = null;
    }

    private void load(String fileName) throws ConfigurationException {
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.load(fileName);
    }

    @Test
    public void testPublic() throws ConfigurationException {
        this.load(PUBLIC_FILE);
    }

    @Test
    public void testRewriteSystem() throws ConfigurationException {
        this.load(REWRITE_SYSTEM_FILE);
    }

    @Test
    public void testSchemaResolver() throws ConfigurationException {
        this.load(REWRITE_SCHEMA_FILE);
    }

    @Test
    public void testDebug() throws Exception {
        this.resolver.setDebug(true);
    }

    @Test
    public void testLogger() throws Exception {
        ConfigurationLogger log = new ConfigurationLogger(this.getClass());
        this.resolver.setLogger(log);
        Assert.assertNotNull((String)"No Logger returned", (Object)this.resolver.getLogger());
        Assert.assertSame((String)"Incorrect Logger", (Object)log, (Object)this.resolver.getLogger());
    }
}

