/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class MockInitialContextFactory
implements InitialContextFactory {
    public static final String PROP_CYCLES = "useCycles";
    private static final String METHOD_LOOKUP = "lookup";
    private static final String METHOD_LIST = "list";
    private static final String METHOD_CLOSE = "close";
    private static final String MISSING_PROP = "/missing";
    private static final String PREFIX = "test/";
    private static final String[] PROP_NAMES = new String[]{"key", "key2", "short", "boolean", "byte", "double", "float", "integer", "long", "onlyinjndi"};
    private static final String[] PROP_VALUES = new String[]{"jndivalue", "jndivalue2", "1", "true", "10", "10.25", "20.25", "10", "1000000", "true"};
    private static final String[] MISSING_NAMES = new String[]{"missing/list", "test/imaginarykey", "foo/bar"};

    public Context getInitialContext(Hashtable env) throws NamingException {
        boolean useCycles = env.containsKey(PROP_CYCLES);
        Mock mockTopCtx = this.createCtxMock(PREFIX);
        Mock mockCycleCtx = this.createCtxMock("");
        Mock mockPrfxCtx = this.createCtxMock("");
        Mock mockBaseCtx = new Mock(Context.class);
        mockBaseCtx.matchAndReturn(METHOD_LOOKUP, (Object)C.eq((Object)""), mockTopCtx.proxy());
        mockBaseCtx.matchAndReturn(METHOD_LOOKUP, (Object)C.eq((Object)"test"), mockPrfxCtx.proxy());
        mockTopCtx.matchAndReturn(METHOD_LOOKUP, (Object)C.eq((Object)"test"), mockPrfxCtx.proxy());
        mockPrfxCtx.matchAndReturn(METHOD_LIST, (Object)C.eq((Object)""), this.createEnumMock(mockPrfxCtx, PROP_NAMES, PROP_VALUES).proxy());
        if (useCycles) {
            mockTopCtx.matchAndReturn(METHOD_LOOKUP, (Object)C.eq((Object)"cycle"), mockCycleCtx.proxy());
            mockTopCtx.matchAndReturn(METHOD_LIST, (Object)C.eq((Object)""), this.createEnumMock(mockTopCtx, new String[]{"test", "cycle"}, new Object[]{mockPrfxCtx.proxy(), mockCycleCtx.proxy()}).proxy());
            Mock mockEnum = this.createEnumMock(mockCycleCtx, PROP_NAMES, PROP_VALUES, false);
            this.addEnumPair(mockEnum, "cycleCtx", mockCycleCtx.proxy());
            this.closeEnum(mockEnum);
            mockCycleCtx.matchAndReturn(METHOD_LIST, (Object)C.eq((Object)""), mockEnum.proxy());
            mockCycleCtx.matchAndReturn(METHOD_LOOKUP, (Object)C.eq((Object)"cycleCtx"), mockCycleCtx.proxy());
        } else {
            mockTopCtx.matchAndReturn(METHOD_LIST, (Object)C.eq((Object)""), this.createEnumMock(mockTopCtx, new String[]{"test"}, new Object[]{mockPrfxCtx.proxy()}).proxy());
        }
        return (Context)mockBaseCtx.proxy();
    }

    private Mock createCtxMock(String prefix) {
        Mock mockCtx = new Mock(Context.class);
        for (int i = 0; i < PROP_NAMES.length; ++i) {
            this.bind(mockCtx, prefix + PROP_NAMES[i], PROP_VALUES[i]);
            String errProp = prefix.length() > 0 ? PROP_NAMES[i] : PREFIX + PROP_NAMES[i];
            this.bindError(mockCtx, errProp);
        }
        for (String element : MISSING_NAMES) {
            this.bindError(mockCtx, element);
        }
        mockCtx.matchAndReturn("hashCode", System.identityHashCode(mockCtx.proxy()));
        return mockCtx;
    }

    private void bind(Mock mockCtx, String name, String value) {
        mockCtx.matchAndReturn(METHOD_LOOKUP, (Object)C.eq((Object)name), (Object)value);
        this.bindError(mockCtx, name + MISSING_PROP);
    }

    private void bindError(Mock mockCtx, String name) {
        mockCtx.matchAndThrow(METHOD_LOOKUP, (Object)C.eq((Object)name), (Throwable)new NameNotFoundException("unknown property"));
    }

    private Mock createEnumMock(Mock mockCtx, String[] names, Object[] values, boolean close) {
        Mock mockEnum = new Mock(NamingEnumeration.class);
        for (int i = 0; i < names.length; ++i) {
            this.addEnumPair(mockEnum, names[i], values[i]);
        }
        if (close) {
            this.closeEnum(mockEnum);
        }
        return mockEnum;
    }

    private Mock createEnumMock(Mock mockCtx, String[] names, Object[] values) {
        return this.createEnumMock(mockCtx, names, values, true);
    }

    private void addEnumPair(Mock mockEnum, String name, Object value) {
        NameClassPair ncp = new NameClassPair(name, value.getClass().getName());
        mockEnum.expectAndReturn("hasMore", true);
        mockEnum.expectAndReturn("next", (Object)ncp);
    }

    private void closeEnum(Mock mockEnum) {
        mockEnum.expectAndReturn("hasMore", false);
        mockEnum.expect(METHOD_CLOSE);
    }
}

