/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.CountingPredicate;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;

@FunctionalInterface
public interface BloomFilterExtractor {
    public static <T extends BloomFilter<T>> BloomFilterExtractor fromBloomFilterArray(final BloomFilter<?> ... filters) {
        Objects.requireNonNull(filters, "filters");
        return new BloomFilterExtractor(){

            @Override
            public BloomFilter[] asBloomFilterArray() {
                return (BloomFilter[])filters.clone();
            }

            @Override
            public boolean processBloomFilterPair(BloomFilterExtractor other, BiPredicate<BloomFilter, BloomFilter> func) {
                CountingPredicate<BloomFilter> p = new CountingPredicate<BloomFilter>(filters, func);
                return other.processBloomFilters(p) && p.processRemaining();
            }

            @Override
            public boolean processBloomFilters(Predicate<BloomFilter> predicate) {
                for (BloomFilter filter : filters) {
                    if (predicate.test(filter)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    default public BloomFilter[] asBloomFilterArray() {
        ArrayList filters = new ArrayList();
        this.processBloomFilters(f -> filters.add(f.copy()));
        return filters.toArray(new BloomFilter[0]);
    }

    default public BloomFilter flatten() {
        AtomicReference ref = new AtomicReference();
        this.processBloomFilters(x -> {
            if (ref.get() == null) {
                ref.set(new SimpleBloomFilter(x.getShape()));
            }
            return ((BloomFilter)ref.get()).merge((BloomFilter<?>)x);
        });
        return Objects.requireNonNull((BloomFilter)ref.get(), "No filters.");
    }

    default public boolean processBloomFilterPair(BloomFilterExtractor other, BiPredicate<BloomFilter, BloomFilter> func) {
        CountingPredicate<BloomFilter> p = new CountingPredicate<BloomFilter>(this.asBloomFilterArray(), func);
        return other.processBloomFilters(p) && p.processRemaining();
    }

    public boolean processBloomFilters(Predicate<BloomFilter> var1);
}

